<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSGeoPoint StructType
 * @subpackage Structs
 */
class WSGeoPoint extends AbstractStructBase
{
    /**
     * The accuracy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $accuracy;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The lat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $lat;
    /**
     * The lon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $lon;
    /**
     * Constructor method for WSGeoPoint
     * @uses WSGeoPoint::setAccuracy()
     * @uses WSGeoPoint::setDescription()
     * @uses WSGeoPoint::setLat()
     * @uses WSGeoPoint::setLon()
     * @param float $accuracy
     * @param string $description
     * @param float $lat
     * @param float $lon
     */
    public function __construct($accuracy = null, $description = null, $lat = null, $lon = null)
    {
        $this
            ->setAccuracy($accuracy)
            ->setDescription($description)
            ->setLat($lat)
            ->setLon($lon);
    }
    /**
     * Get accuracy value
     * @return float|null
     */
    public function getAccuracy()
    {
        return $this->accuracy;
    }
    /**
     * Set accuracy value
     * @param float $accuracy
     * @return \StructType\WSGeoPoint
     */
    public function setAccuracy($accuracy = null)
    {
        // validation for constraint: float
        if (!is_null($accuracy) && !(is_float($accuracy) || is_numeric($accuracy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($accuracy, true), gettype($accuracy)), __LINE__);
        }
        $this->accuracy = $accuracy;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\WSGeoPoint
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get lat value
     * @return float|null
     */
    public function getLat()
    {
        return $this->lat;
    }
    /**
     * Set lat value
     * @param float $lat
     * @return \StructType\WSGeoPoint
     */
    public function setLat($lat = null)
    {
        // validation for constraint: float
        if (!is_null($lat) && !(is_float($lat) || is_numeric($lat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lat, true), gettype($lat)), __LINE__);
        }
        $this->lat = $lat;
        return $this;
    }
    /**
     * Get lon value
     * @return float|null
     */
    public function getLon()
    {
        return $this->lon;
    }
    /**
     * Set lon value
     * @param float $lon
     * @return \StructType\WSGeoPoint
     */
    public function setLon($lon = null)
    {
        // validation for constraint: float
        if (!is_null($lon) && !(is_float($lon) || is_numeric($lon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lon, true), gettype($lon)), __LINE__);
        }
        $this->lon = $lon;
        return $this;
    }
}
