<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSGenericProperty StructType
 * @subpackage Structs
 */
class WSGenericProperty extends AbstractStructBase
{
    /**
     * The action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $action;
    /**
     * The boolValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $boolValue;
    /**
     * The decValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $decValue;
    /**
     * The decValue2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $decValue2;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $key;
    /**
     * The linkID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $linkID;
    /**
     * The linkType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $linkType;
    /**
     * The realValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $realValue;
    /**
     * The strValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $strValue;
    /**
     * The validFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $validFrom;
    /**
     * The validTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $validTo;
    /**
     * Constructor method for WSGenericProperty
     * @uses WSGenericProperty::setAction()
     * @uses WSGenericProperty::setBoolValue()
     * @uses WSGenericProperty::setDecValue()
     * @uses WSGenericProperty::setDecValue2()
     * @uses WSGenericProperty::setId()
     * @uses WSGenericProperty::setKey()
     * @uses WSGenericProperty::setLinkID()
     * @uses WSGenericProperty::setLinkType()
     * @uses WSGenericProperty::setRealValue()
     * @uses WSGenericProperty::setStrValue()
     * @uses WSGenericProperty::setValidFrom()
     * @uses WSGenericProperty::setValidTo()
     * @param int $action
     * @param bool $boolValue
     * @param int $decValue
     * @param int $decValue2
     * @param int $id
     * @param int $key
     * @param int $linkID
     * @param int $linkType
     * @param float $realValue
     * @param string $strValue
     * @param \StructType\WSTimestamp $validFrom
     * @param \StructType\WSTimestamp $validTo
     */
    public function __construct($action = null, $boolValue = null, $decValue = null, $decValue2 = null, $id = null, $key = null, $linkID = null, $linkType = null, $realValue = null, $strValue = null, \StructType\WSTimestamp $validFrom = null, \StructType\WSTimestamp $validTo = null)
    {
        $this
            ->setAction($action)
            ->setBoolValue($boolValue)
            ->setDecValue($decValue)
            ->setDecValue2($decValue2)
            ->setId($id)
            ->setKey($key)
            ->setLinkID($linkID)
            ->setLinkType($linkType)
            ->setRealValue($realValue)
            ->setStrValue($strValue)
            ->setValidFrom($validFrom)
            ->setValidTo($validTo);
    }
    /**
     * Get action value
     * @return int|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param int $action
     * @return \StructType\WSGenericProperty
     */
    public function setAction($action = null)
    {
        // validation for constraint: int
        if (!is_null($action) && !(is_int($action) || ctype_digit($action))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get boolValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBoolValue()
    {
        return isset($this->boolValue) ? $this->boolValue : null;
    }
    /**
     * Set boolValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $boolValue
     * @return \StructType\WSGenericProperty
     */
    public function setBoolValue($boolValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($boolValue) && !is_bool($boolValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($boolValue, true), gettype($boolValue)), __LINE__);
        }
        if (is_null($boolValue) || (is_array($boolValue) && empty($boolValue))) {
            unset($this->boolValue);
        } else {
            $this->boolValue = $boolValue;
        }
        return $this;
    }
    /**
     * Get decValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDecValue()
    {
        return isset($this->decValue) ? $this->decValue : null;
    }
    /**
     * Set decValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $decValue
     * @return \StructType\WSGenericProperty
     */
    public function setDecValue($decValue = null)
    {
        // validation for constraint: int
        if (!is_null($decValue) && !(is_int($decValue) || ctype_digit($decValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decValue, true), gettype($decValue)), __LINE__);
        }
        if (is_null($decValue) || (is_array($decValue) && empty($decValue))) {
            unset($this->decValue);
        } else {
            $this->decValue = $decValue;
        }
        return $this;
    }
    /**
     * Get decValue2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDecValue2()
    {
        return isset($this->decValue2) ? $this->decValue2 : null;
    }
    /**
     * Set decValue2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $decValue2
     * @return \StructType\WSGenericProperty
     */
    public function setDecValue2($decValue2 = null)
    {
        // validation for constraint: int
        if (!is_null($decValue2) && !(is_int($decValue2) || ctype_digit($decValue2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decValue2, true), gettype($decValue2)), __LINE__);
        }
        if (is_null($decValue2) || (is_array($decValue2) && empty($decValue2))) {
            unset($this->decValue2);
        } else {
            $this->decValue2 = $decValue2;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\WSGenericProperty
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get key value
     * @return int|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param int $key
     * @return \StructType\WSGenericProperty
     */
    public function setKey($key = null)
    {
        // validation for constraint: int
        if (!is_null($key) && !(is_int($key) || ctype_digit($key))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get linkID value
     * @return int|null
     */
    public function getLinkID()
    {
        return $this->linkID;
    }
    /**
     * Set linkID value
     * @param int $linkID
     * @return \StructType\WSGenericProperty
     */
    public function setLinkID($linkID = null)
    {
        // validation for constraint: int
        if (!is_null($linkID) && !(is_int($linkID) || ctype_digit($linkID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkID, true), gettype($linkID)), __LINE__);
        }
        $this->linkID = $linkID;
        return $this;
    }
    /**
     * Get linkType value
     * @return int|null
     */
    public function getLinkType()
    {
        return $this->linkType;
    }
    /**
     * Set linkType value
     * @param int $linkType
     * @return \StructType\WSGenericProperty
     */
    public function setLinkType($linkType = null)
    {
        // validation for constraint: int
        if (!is_null($linkType) && !(is_int($linkType) || ctype_digit($linkType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkType, true), gettype($linkType)), __LINE__);
        }
        $this->linkType = $linkType;
        return $this;
    }
    /**
     * Get realValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRealValue()
    {
        return isset($this->realValue) ? $this->realValue : null;
    }
    /**
     * Set realValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $realValue
     * @return \StructType\WSGenericProperty
     */
    public function setRealValue($realValue = null)
    {
        // validation for constraint: float
        if (!is_null($realValue) && !(is_float($realValue) || is_numeric($realValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($realValue, true), gettype($realValue)), __LINE__);
        }
        if (is_null($realValue) || (is_array($realValue) && empty($realValue))) {
            unset($this->realValue);
        } else {
            $this->realValue = $realValue;
        }
        return $this;
    }
    /**
     * Get strValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStrValue()
    {
        return isset($this->strValue) ? $this->strValue : null;
    }
    /**
     * Set strValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $strValue
     * @return \StructType\WSGenericProperty
     */
    public function setStrValue($strValue = null)
    {
        // validation for constraint: string
        if (!is_null($strValue) && !is_string($strValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strValue, true), gettype($strValue)), __LINE__);
        }
        if (is_null($strValue) || (is_array($strValue) && empty($strValue))) {
            unset($this->strValue);
        } else {
            $this->strValue = $strValue;
        }
        return $this;
    }
    /**
     * Get validFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getValidFrom()
    {
        return isset($this->validFrom) ? $this->validFrom : null;
    }
    /**
     * Set validFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $validFrom
     * @return \StructType\WSGenericProperty
     */
    public function setValidFrom(\StructType\WSTimestamp $validFrom = null)
    {
        if (is_null($validFrom) || (is_array($validFrom) && empty($validFrom))) {
            unset($this->validFrom);
        } else {
            $this->validFrom = $validFrom;
        }
        return $this;
    }
    /**
     * Get validTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getValidTo()
    {
        return isset($this->validTo) ? $this->validTo : null;
    }
    /**
     * Set validTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $validTo
     * @return \StructType\WSGenericProperty
     */
    public function setValidTo(\StructType\WSTimestamp $validTo = null)
    {
        if (is_null($validTo) || (is_array($validTo) && empty($validTo))) {
            unset($this->validTo);
        } else {
            $this->validTo = $validTo;
        }
        return $this;
    }
}
