<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSExtensibleLevel StructType
 * @subpackage Structs
 */
class WSExtensibleLevel extends BasicExtensibleObject
{
    /**
     * The wsLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLevel
     */
    public $wsLevel;
    /**
     * Constructor method for WSExtensibleLevel
     * @uses WSExtensibleLevel::setWsLevel()
     * @param \StructType\WSLevel $wsLevel
     */
    public function __construct(\StructType\WSLevel $wsLevel = null)
    {
        $this
            ->setWsLevel($wsLevel);
    }
    /**
     * Get wsLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLevel|null
     */
    public function getWsLevel()
    {
        return isset($this->wsLevel) ? $this->wsLevel : null;
    }
    /**
     * Set wsLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSLevel $wsLevel
     * @return \StructType\WSExtensibleLevel
     */
    public function setWsLevel(\StructType\WSLevel $wsLevel = null)
    {
        if (is_null($wsLevel) || (is_array($wsLevel) && empty($wsLevel))) {
            unset($this->wsLevel);
        } else {
            $this->wsLevel = $wsLevel;
        }
        return $this;
    }
}
