<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSLevelIdentification StructType
 * @subpackage Structs
 */
class WSLevelIdentification extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The levelID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $levelID;
    /**
     * Constructor method for WSLevelIdentification
     * @uses WSLevelIdentification::setCode()
     * @uses WSLevelIdentification::setLevelID()
     * @param string $code
     * @param int $levelID
     */
    public function __construct($code = null, $levelID = null)
    {
        $this
            ->setCode($code)
            ->setLevelID($levelID);
    }
    /**
     * Get code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * Set code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\WSLevelIdentification
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get levelID value
     * @return int|null
     */
    public function getLevelID()
    {
        return $this->levelID;
    }
    /**
     * Set levelID value
     * @param int $levelID
     * @return \StructType\WSLevelIdentification
     */
    public function setLevelID($levelID = null)
    {
        // validation for constraint: int
        if (!is_null($levelID) && !(is_int($levelID) || ctype_digit($levelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($levelID, true), gettype($levelID)), __LINE__);
        }
        $this->levelID = $levelID;
        return $this;
    }
}
