<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSCustomTerminalInfo StructType
 * @subpackage Structs
 */
class WSCustomTerminalInfo extends AbstractStructBase
{
    /**
     * The cardId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cardId;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSKeyValueGroup
     */
    public $extensions;
    /**
     * The infoLines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfString_1
     */
    public $infoLines;
    /**
     * Constructor method for WSCustomTerminalInfo
     * @uses WSCustomTerminalInfo::setCardId()
     * @uses WSCustomTerminalInfo::setExtensions()
     * @uses WSCustomTerminalInfo::setInfoLines()
     * @param string $cardId
     * @param \StructType\WSKeyValueGroup $extensions
     * @param \ArrayType\ArrayOfString_1 $infoLines
     */
    public function __construct($cardId = null, \StructType\WSKeyValueGroup $extensions = null, \ArrayType\ArrayOfString_1 $infoLines = null)
    {
        $this
            ->setCardId($cardId)
            ->setExtensions($extensions)
            ->setInfoLines($infoLines);
    }
    /**
     * Get cardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardId()
    {
        return isset($this->cardId) ? $this->cardId : null;
    }
    /**
     * Set cardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardId
     * @return \StructType\WSCustomTerminalInfo
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        if (is_null($cardId) || (is_array($cardId) && empty($cardId))) {
            unset($this->cardId);
        } else {
            $this->cardId = $cardId;
        }
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSKeyValueGroup|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSKeyValueGroup $extensions
     * @return \StructType\WSCustomTerminalInfo
     */
    public function setExtensions(\StructType\WSKeyValueGroup $extensions = null)
    {
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Get infoLines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfString_1|null
     */
    public function getInfoLines()
    {
        return isset($this->infoLines) ? $this->infoLines : null;
    }
    /**
     * Set infoLines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfString_1 $infoLines
     * @return \StructType\WSCustomTerminalInfo
     */
    public function setInfoLines(\ArrayType\ArrayOfString_1 $infoLines = null)
    {
        if (is_null($infoLines) || (is_array($infoLines) && empty($infoLines))) {
            unset($this->infoLines);
        } else {
            $this->infoLines = $infoLines;
        }
        return $this;
    }
}
