<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSAccount StructType
 * @subpackage Structs
 */
class WSAccount extends AbstractStructBase
{
    /**
     * The TS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $TS;
    /**
     * The accountDefinitionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $accountDefinitionId;
    /**
     * The linkId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $linkId;
    /**
     * The linkType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $linkType;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $value;
    /**
     * Constructor method for WSAccount
     * @uses WSAccount::setTS()
     * @uses WSAccount::setAccountDefinitionId()
     * @uses WSAccount::setLinkId()
     * @uses WSAccount::setLinkType()
     * @uses WSAccount::setValue()
     * @param \StructType\WSTimestamp $tS
     * @param int $accountDefinitionId
     * @param int $linkId
     * @param int $linkType
     * @param int $value
     */
    public function __construct(\StructType\WSTimestamp $tS = null, $accountDefinitionId = null, $linkId = null, $linkType = null, $value = null)
    {
        $this
            ->setTS($tS)
            ->setAccountDefinitionId($accountDefinitionId)
            ->setLinkId($linkId)
            ->setLinkType($linkType)
            ->setValue($value);
    }
    /**
     * Get TS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getTS()
    {
        return isset($this->TS) ? $this->TS : null;
    }
    /**
     * Set TS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $tS
     * @return \StructType\WSAccount
     */
    public function setTS(\StructType\WSTimestamp $tS = null)
    {
        if (is_null($tS) || (is_array($tS) && empty($tS))) {
            unset($this->TS);
        } else {
            $this->TS = $tS;
        }
        return $this;
    }
    /**
     * Get accountDefinitionId value
     * @return int|null
     */
    public function getAccountDefinitionId()
    {
        return $this->accountDefinitionId;
    }
    /**
     * Set accountDefinitionId value
     * @param int $accountDefinitionId
     * @return \StructType\WSAccount
     */
    public function setAccountDefinitionId($accountDefinitionId = null)
    {
        // validation for constraint: int
        if (!is_null($accountDefinitionId) && !(is_int($accountDefinitionId) || ctype_digit($accountDefinitionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountDefinitionId, true), gettype($accountDefinitionId)), __LINE__);
        }
        $this->accountDefinitionId = $accountDefinitionId;
        return $this;
    }
    /**
     * Get linkId value
     * @return int|null
     */
    public function getLinkId()
    {
        return $this->linkId;
    }
    /**
     * Set linkId value
     * @param int $linkId
     * @return \StructType\WSAccount
     */
    public function setLinkId($linkId = null)
    {
        // validation for constraint: int
        if (!is_null($linkId) && !(is_int($linkId) || ctype_digit($linkId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkId, true), gettype($linkId)), __LINE__);
        }
        $this->linkId = $linkId;
        return $this;
    }
    /**
     * Get linkType value
     * @return int|null
     */
    public function getLinkType()
    {
        return $this->linkType;
    }
    /**
     * Set linkType value
     * @param int $linkType
     * @return \StructType\WSAccount
     */
    public function setLinkType($linkType = null)
    {
        // validation for constraint: int
        if (!is_null($linkType) && !(is_int($linkType) || ctype_digit($linkType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkType, true), gettype($linkType)), __LINE__);
        }
        $this->linkType = $linkType;
        return $this;
    }
    /**
     * Get value value
     * @return int|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param int $value
     * @return \StructType\WSAccount
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
