<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSCustomTerminalInfoBlock StructType
 * @subpackage Structs
 */
class WSCustomTerminalInfoBlock extends AbstractStructBase
{
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSKeyValueGroup
     */
    public $extensions;
    /**
     * The information
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSCustomTerminalInfo
     */
    public $information;
    /**
     * The terminalNr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $terminalNr;
    /**
     * Constructor method for WSCustomTerminalInfoBlock
     * @uses WSCustomTerminalInfoBlock::setExtensions()
     * @uses WSCustomTerminalInfoBlock::setInformation()
     * @uses WSCustomTerminalInfoBlock::setTerminalNr()
     * @param \StructType\WSKeyValueGroup $extensions
     * @param \ArrayType\ArrayOfWSCustomTerminalInfo $information
     * @param int $terminalNr
     */
    public function __construct(\StructType\WSKeyValueGroup $extensions = null, \ArrayType\ArrayOfWSCustomTerminalInfo $information = null, $terminalNr = null)
    {
        $this
            ->setExtensions($extensions)
            ->setInformation($information)
            ->setTerminalNr($terminalNr);
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSKeyValueGroup|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSKeyValueGroup $extensions
     * @return \StructType\WSCustomTerminalInfoBlock
     */
    public function setExtensions(\StructType\WSKeyValueGroup $extensions = null)
    {
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Get information value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSCustomTerminalInfo|null
     */
    public function getInformation()
    {
        return isset($this->information) ? $this->information : null;
    }
    /**
     * Set information value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSCustomTerminalInfo $information
     * @return \StructType\WSCustomTerminalInfoBlock
     */
    public function setInformation(\ArrayType\ArrayOfWSCustomTerminalInfo $information = null)
    {
        if (is_null($information) || (is_array($information) && empty($information))) {
            unset($this->information);
        } else {
            $this->information = $information;
        }
        return $this;
    }
    /**
     * Get terminalNr value
     * @return int|null
     */
    public function getTerminalNr()
    {
        return $this->terminalNr;
    }
    /**
     * Set terminalNr value
     * @param int $terminalNr
     * @return \StructType\WSCustomTerminalInfoBlock
     */
    public function setTerminalNr($terminalNr = null)
    {
        // validation for constraint: int
        if (!is_null($terminalNr) && !(is_int($terminalNr) || ctype_digit($terminalNr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalNr, true), gettype($terminalNr)), __LINE__);
        }
        $this->terminalNr = $terminalNr;
        return $this;
    }
}
