<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Perform ServiceType
 * @subpackage Services
 */
class Perform extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named performTaskAction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PerformTaskAction $parameters
     * @return \StructType\PerformTaskActionResponse|bool
     */
    public function performTaskAction(\StructType\PerformTaskAction $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->performTaskAction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PerformTaskActionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
