<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSAttachedDocument StructType
 * @subpackage Structs
 */
class WSAttachedDocument extends AbstractStructBase
{
    /**
     * The directory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $directory;
    /**
     * The downloadURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $downloadURL;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $id;
    /**
     * The properties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $properties;
    /**
     * The subEntries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSAttachedDocument
     */
    public $subEntries;
    /**
     * Constructor method for WSAttachedDocument
     * @uses WSAttachedDocument::setDirectory()
     * @uses WSAttachedDocument::setDownloadURL()
     * @uses WSAttachedDocument::setId()
     * @uses WSAttachedDocument::setProperties()
     * @uses WSAttachedDocument::setSubEntries()
     * @param bool $directory
     * @param string $downloadURL
     * @param string $id
     * @param \ArrayType\ArrayOfWSKeyValue $properties
     * @param \ArrayType\ArrayOfWSAttachedDocument $subEntries
     */
    public function __construct($directory = null, $downloadURL = null, $id = null, \ArrayType\ArrayOfWSKeyValue $properties = null, \ArrayType\ArrayOfWSAttachedDocument $subEntries = null)
    {
        $this
            ->setDirectory($directory)
            ->setDownloadURL($downloadURL)
            ->setId($id)
            ->setProperties($properties)
            ->setSubEntries($subEntries);
    }
    /**
     * Get directory value
     * @return bool|null
     */
    public function getDirectory()
    {
        return $this->directory;
    }
    /**
     * Set directory value
     * @param bool $directory
     * @return \StructType\WSAttachedDocument
     */
    public function setDirectory($directory = null)
    {
        // validation for constraint: boolean
        if (!is_null($directory) && !is_bool($directory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directory, true), gettype($directory)), __LINE__);
        }
        $this->directory = $directory;
        return $this;
    }
    /**
     * Get downloadURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDownloadURL()
    {
        return isset($this->downloadURL) ? $this->downloadURL : null;
    }
    /**
     * Set downloadURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $downloadURL
     * @return \StructType\WSAttachedDocument
     */
    public function setDownloadURL($downloadURL = null)
    {
        // validation for constraint: string
        if (!is_null($downloadURL) && !is_string($downloadURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($downloadURL, true), gettype($downloadURL)), __LINE__);
        }
        if (is_null($downloadURL) || (is_array($downloadURL) && empty($downloadURL))) {
            unset($this->downloadURL);
        } else {
            $this->downloadURL = $downloadURL;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \StructType\WSAttachedDocument
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get properties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getProperties()
    {
        return isset($this->properties) ? $this->properties : null;
    }
    /**
     * Set properties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $properties
     * @return \StructType\WSAttachedDocument
     */
    public function setProperties(\ArrayType\ArrayOfWSKeyValue $properties = null)
    {
        if (is_null($properties) || (is_array($properties) && empty($properties))) {
            unset($this->properties);
        } else {
            $this->properties = $properties;
        }
        return $this;
    }
    /**
     * Get subEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSAttachedDocument|null
     */
    public function getSubEntries()
    {
        return isset($this->subEntries) ? $this->subEntries : null;
    }
    /**
     * Set subEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSAttachedDocument $subEntries
     * @return \StructType\WSAttachedDocument
     */
    public function setSubEntries(\ArrayType\ArrayOfWSAttachedDocument $subEntries = null)
    {
        if (is_null($subEntries) || (is_array($subEntries) && empty($subEntries))) {
            unset($this->subEntries);
        } else {
            $this->subEntries = $subEntries;
        }
        return $this;
    }
}
