<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSAccount ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSAccount extends AbstractStructArrayBase
{
    /**
     * The WSAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSAccount[]
     */
    public $WSAccount;
    /**
     * Constructor method for ArrayOfWSAccount
     * @uses ArrayOfWSAccount::setWSAccount()
     * @param \StructType\WSAccount[] $wSAccount
     */
    public function __construct(array $wSAccount = array())
    {
        $this
            ->setWSAccount($wSAccount);
    }
    /**
     * Get WSAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSAccount[]|null
     */
    public function getWSAccount()
    {
        return isset($this->WSAccount) ? $this->WSAccount : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSAccountForArrayConstraintsFromSetWSAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSAccountWSAccountItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSAccountWSAccountItem instanceof \StructType\WSAccount) {
                $invalidValues[] = is_object($arrayOfWSAccountWSAccountItem) ? get_class($arrayOfWSAccountWSAccountItem) : sprintf('%s(%s)', gettype($arrayOfWSAccountWSAccountItem), var_export($arrayOfWSAccountWSAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSAccount property can only contain items of type \StructType\WSAccount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSAccount[] $wSAccount
     * @return \ArrayType\ArrayOfWSAccount
     */
    public function setWSAccount(array $wSAccount = array())
    {
        // validation for constraint: array
        if ('' !== ($wSAccountArrayErrorMessage = self::validateWSAccountForArrayConstraintsFromSetWSAccount($wSAccount))) {
            throw new \InvalidArgumentException($wSAccountArrayErrorMessage, __LINE__);
        }
        if (is_null($wSAccount) || (is_array($wSAccount) && empty($wSAccount))) {
            unset($this->WSAccount);
        } else {
            $this->WSAccount = $wSAccount;
        }
        return $this;
    }
    /**
     * Add item to WSAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\WSAccount $item
     * @return \ArrayType\ArrayOfWSAccount
     */
    public function addToWSAccount(\StructType\WSAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSAccount) {
            throw new \InvalidArgumentException(sprintf('The WSAccount property can only contain items of type \StructType\WSAccount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSAccount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSAccount|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSAccount|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSAccount|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSAccount|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSAccount|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSAccount
     */
    public function getAttributeName()
    {
        return 'WSAccount';
    }
}
