<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSEntryDoor StructType
 * @subpackage Structs
 */
class WSEntryDoor extends AbstractStructBase
{
    /**
     * The hardwareID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $hardwareID;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The terminalSlot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $terminalSlot;
    /**
     * Constructor method for WSEntryDoor
     * @uses WSEntryDoor::setHardwareID()
     * @uses WSEntryDoor::setId()
     * @uses WSEntryDoor::setName()
     * @uses WSEntryDoor::setTerminalSlot()
     * @param string $hardwareID
     * @param int $id
     * @param string $name
     * @param int $terminalSlot
     */
    public function __construct($hardwareID = null, $id = null, $name = null, $terminalSlot = null)
    {
        $this
            ->setHardwareID($hardwareID)
            ->setId($id)
            ->setName($name)
            ->setTerminalSlot($terminalSlot);
    }
    /**
     * Get hardwareID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHardwareID()
    {
        return isset($this->hardwareID) ? $this->hardwareID : null;
    }
    /**
     * Set hardwareID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hardwareID
     * @return \StructType\WSEntryDoor
     */
    public function setHardwareID($hardwareID = null)
    {
        // validation for constraint: string
        if (!is_null($hardwareID) && !is_string($hardwareID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hardwareID, true), gettype($hardwareID)), __LINE__);
        }
        if (is_null($hardwareID) || (is_array($hardwareID) && empty($hardwareID))) {
            unset($this->hardwareID);
        } else {
            $this->hardwareID = $hardwareID;
        }
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\WSEntryDoor
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\WSEntryDoor
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get terminalSlot value
     * @return int|null
     */
    public function getTerminalSlot()
    {
        return $this->terminalSlot;
    }
    /**
     * Set terminalSlot value
     * @param int $terminalSlot
     * @return \StructType\WSEntryDoor
     */
    public function setTerminalSlot($terminalSlot = null)
    {
        // validation for constraint: int
        if (!is_null($terminalSlot) && !(is_int($terminalSlot) || ctype_digit($terminalSlot))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalSlot, true), gettype($terminalSlot)), __LINE__);
        }
        $this->terminalSlot = $terminalSlot;
        return $this;
    }
}
