<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSLevel ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSLevel extends AbstractStructArrayBase
{
    /**
     * The WSLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLevel[]
     */
    public $WSLevel;
    /**
     * Constructor method for ArrayOfWSLevel
     * @uses ArrayOfWSLevel::setWSLevel()
     * @param \StructType\WSLevel[] $wSLevel
     */
    public function __construct(array $wSLevel = array())
    {
        $this
            ->setWSLevel($wSLevel);
    }
    /**
     * Get WSLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLevel[]|null
     */
    public function getWSLevel()
    {
        return isset($this->WSLevel) ? $this->WSLevel : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSLevel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSLevel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSLevelForArrayConstraintsFromSetWSLevel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSLevelWSLevelItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSLevelWSLevelItem instanceof \StructType\WSLevel) {
                $invalidValues[] = is_object($arrayOfWSLevelWSLevelItem) ? get_class($arrayOfWSLevelWSLevelItem) : sprintf('%s(%s)', gettype($arrayOfWSLevelWSLevelItem), var_export($arrayOfWSLevelWSLevelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSLevel property can only contain items of type \StructType\WSLevel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSLevel[] $wSLevel
     * @return \ArrayType\ArrayOfWSLevel
     */
    public function setWSLevel(array $wSLevel = array())
    {
        // validation for constraint: array
        if ('' !== ($wSLevelArrayErrorMessage = self::validateWSLevelForArrayConstraintsFromSetWSLevel($wSLevel))) {
            throw new \InvalidArgumentException($wSLevelArrayErrorMessage, __LINE__);
        }
        if (is_null($wSLevel) || (is_array($wSLevel) && empty($wSLevel))) {
            unset($this->WSLevel);
        } else {
            $this->WSLevel = $wSLevel;
        }
        return $this;
    }
    /**
     * Add item to WSLevel value
     * @throws \InvalidArgumentException
     * @param \StructType\WSLevel $item
     * @return \ArrayType\ArrayOfWSLevel
     */
    public function addToWSLevel(\StructType\WSLevel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSLevel) {
            throw new \InvalidArgumentException(sprintf('The WSLevel property can only contain items of type \StructType\WSLevel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSLevel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSLevel|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSLevel|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSLevel|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSLevel|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSLevel|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSLevel
     */
    public function getAttributeName()
    {
        return 'WSLevel';
    }
}
