<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTaskModification StructType
 * @subpackage Structs
 */
class WSTaskModification extends AbstractStructBase
{
    /**
     * The modifications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSModification
     */
    public $modifications;
    /**
     * The taskId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $taskId;
    /**
     * Constructor method for WSTaskModification
     * @uses WSTaskModification::setModifications()
     * @uses WSTaskModification::setTaskId()
     * @param \ArrayType\ArrayOfWSModification $modifications
     * @param int $taskId
     */
    public function __construct(\ArrayType\ArrayOfWSModification $modifications = null, $taskId = null)
    {
        $this
            ->setModifications($modifications)
            ->setTaskId($taskId);
    }
    /**
     * Get modifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSModification|null
     */
    public function getModifications()
    {
        return isset($this->modifications) ? $this->modifications : null;
    }
    /**
     * Set modifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSModification $modifications
     * @return \StructType\WSTaskModification
     */
    public function setModifications(\ArrayType\ArrayOfWSModification $modifications = null)
    {
        if (is_null($modifications) || (is_array($modifications) && empty($modifications))) {
            unset($this->modifications);
        } else {
            $this->modifications = $modifications;
        }
        return $this;
    }
    /**
     * Get taskId value
     * @return int|null
     */
    public function getTaskId()
    {
        return $this->taskId;
    }
    /**
     * Set taskId value
     * @param int $taskId
     * @return \StructType\WSTaskModification
     */
    public function setTaskId($taskId = null)
    {
        // validation for constraint: int
        if (!is_null($taskId) && !(is_int($taskId) || ctype_digit($taskId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taskId, true), gettype($taskId)), __LINE__);
        }
        $this->taskId = $taskId;
        return $this;
    }
}
