<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTripModification StructType
 * @subpackage Structs
 */
class WSTripModification extends AbstractStructBase
{
    /**
     * The modifications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSModification
     */
    public $modifications;
    /**
     * The tripId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tripId;
    /**
     * Constructor method for WSTripModification
     * @uses WSTripModification::setModifications()
     * @uses WSTripModification::setTripId()
     * @param \ArrayType\ArrayOfWSModification $modifications
     * @param int $tripId
     */
    public function __construct(\ArrayType\ArrayOfWSModification $modifications = null, $tripId = null)
    {
        $this
            ->setModifications($modifications)
            ->setTripId($tripId);
    }
    /**
     * Get modifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSModification|null
     */
    public function getModifications()
    {
        return isset($this->modifications) ? $this->modifications : null;
    }
    /**
     * Set modifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSModification $modifications
     * @return \StructType\WSTripModification
     */
    public function setModifications(\ArrayType\ArrayOfWSModification $modifications = null)
    {
        if (is_null($modifications) || (is_array($modifications) && empty($modifications))) {
            unset($this->modifications);
        } else {
            $this->modifications = $modifications;
        }
        return $this;
    }
    /**
     * Get tripId value
     * @return int|null
     */
    public function getTripId()
    {
        return $this->tripId;
    }
    /**
     * Set tripId value
     * @param int $tripId
     * @return \StructType\WSTripModification
     */
    public function setTripId($tripId = null)
    {
        // validation for constraint: int
        if (!is_null($tripId) && !(is_int($tripId) || ctype_digit($tripId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tripId, true), gettype($tripId)), __LINE__);
        }
        $this->tripId = $tripId;
        return $this;
    }
}
