<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSTaskInput ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSTaskInput extends AbstractStructArrayBase
{
    /**
     * The WSTaskInput
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTaskInput[]
     */
    public $WSTaskInput;
    /**
     * Constructor method for ArrayOfWSTaskInput
     * @uses ArrayOfWSTaskInput::setWSTaskInput()
     * @param \StructType\WSTaskInput[] $wSTaskInput
     */
    public function __construct(array $wSTaskInput = array())
    {
        $this
            ->setWSTaskInput($wSTaskInput);
    }
    /**
     * Get WSTaskInput value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTaskInput[]|null
     */
    public function getWSTaskInput()
    {
        return isset($this->WSTaskInput) ? $this->WSTaskInput : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSTaskInput method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSTaskInput method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSTaskInputForArrayConstraintsFromSetWSTaskInput(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSTaskInputWSTaskInputItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSTaskInputWSTaskInputItem instanceof \StructType\WSTaskInput) {
                $invalidValues[] = is_object($arrayOfWSTaskInputWSTaskInputItem) ? get_class($arrayOfWSTaskInputWSTaskInputItem) : sprintf('%s(%s)', gettype($arrayOfWSTaskInputWSTaskInputItem), var_export($arrayOfWSTaskInputWSTaskInputItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSTaskInput property can only contain items of type \StructType\WSTaskInput, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSTaskInput value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSTaskInput[] $wSTaskInput
     * @return \ArrayType\ArrayOfWSTaskInput
     */
    public function setWSTaskInput(array $wSTaskInput = array())
    {
        // validation for constraint: array
        if ('' !== ($wSTaskInputArrayErrorMessage = self::validateWSTaskInputForArrayConstraintsFromSetWSTaskInput($wSTaskInput))) {
            throw new \InvalidArgumentException($wSTaskInputArrayErrorMessage, __LINE__);
        }
        if (is_null($wSTaskInput) || (is_array($wSTaskInput) && empty($wSTaskInput))) {
            unset($this->WSTaskInput);
        } else {
            $this->WSTaskInput = $wSTaskInput;
        }
        return $this;
    }
    /**
     * Add item to WSTaskInput value
     * @throws \InvalidArgumentException
     * @param \StructType\WSTaskInput $item
     * @return \ArrayType\ArrayOfWSTaskInput
     */
    public function addToWSTaskInput(\StructType\WSTaskInput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSTaskInput) {
            throw new \InvalidArgumentException(sprintf('The WSTaskInput property can only contain items of type \StructType\WSTaskInput, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSTaskInput[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSTaskInput|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSTaskInput|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSTaskInput|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSTaskInput|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSTaskInput|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSTaskInput
     */
    public function getAttributeName()
    {
        return 'WSTaskInput';
    }
}
