<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSEntryTerminal StructType
 * @subpackage Structs
 */
class WSEntryTerminal extends AbstractStructBase
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $address;
    /**
     * The doors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSEntryDoor
     */
    public $doors;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSExtension
     */
    public $extensions;
    /**
     * The genericProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSGenericProperty
     */
    public $genericProperties;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $number;
    /**
     * The parentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $parentID;
    /**
     * The subTerminals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSEntryTerminal
     */
    public $subTerminals;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $type;
    /**
     * Constructor method for WSEntryTerminal
     * @uses WSEntryTerminal::setAddress()
     * @uses WSEntryTerminal::setDoors()
     * @uses WSEntryTerminal::setExtensions()
     * @uses WSEntryTerminal::setGenericProperties()
     * @uses WSEntryTerminal::setId()
     * @uses WSEntryTerminal::setName()
     * @uses WSEntryTerminal::setNumber()
     * @uses WSEntryTerminal::setParentID()
     * @uses WSEntryTerminal::setSubTerminals()
     * @uses WSEntryTerminal::setType()
     * @param string $address
     * @param \ArrayType\ArrayOfWSEntryDoor $doors
     * @param \ArrayType\ArrayOfWSExtension $extensions
     * @param \ArrayType\ArrayOfWSGenericProperty $genericProperties
     * @param int $id
     * @param string $name
     * @param int $number
     * @param int $parentID
     * @param \ArrayType\ArrayOfWSEntryTerminal $subTerminals
     * @param int $type
     */
    public function __construct($address = null, \ArrayType\ArrayOfWSEntryDoor $doors = null, \ArrayType\ArrayOfWSExtension $extensions = null, \ArrayType\ArrayOfWSGenericProperty $genericProperties = null, $id = null, $name = null, $number = null, $parentID = null, \ArrayType\ArrayOfWSEntryTerminal $subTerminals = null, $type = null)
    {
        $this
            ->setAddress($address)
            ->setDoors($doors)
            ->setExtensions($extensions)
            ->setGenericProperties($genericProperties)
            ->setId($id)
            ->setName($name)
            ->setNumber($number)
            ->setParentID($parentID)
            ->setSubTerminals($subTerminals)
            ->setType($type);
    }
    /**
     * Get address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->address) ? $this->address : null;
    }
    /**
     * Set address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \StructType\WSEntryTerminal
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->address);
        } else {
            $this->address = $address;
        }
        return $this;
    }
    /**
     * Get doors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSEntryDoor|null
     */
    public function getDoors()
    {
        return isset($this->doors) ? $this->doors : null;
    }
    /**
     * Set doors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSEntryDoor $doors
     * @return \StructType\WSEntryTerminal
     */
    public function setDoors(\ArrayType\ArrayOfWSEntryDoor $doors = null)
    {
        if (is_null($doors) || (is_array($doors) && empty($doors))) {
            unset($this->doors);
        } else {
            $this->doors = $doors;
        }
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSExtension|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSExtension $extensions
     * @return \StructType\WSEntryTerminal
     */
    public function setExtensions(\ArrayType\ArrayOfWSExtension $extensions = null)
    {
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Get genericProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSGenericProperty|null
     */
    public function getGenericProperties()
    {
        return isset($this->genericProperties) ? $this->genericProperties : null;
    }
    /**
     * Set genericProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSGenericProperty $genericProperties
     * @return \StructType\WSEntryTerminal
     */
    public function setGenericProperties(\ArrayType\ArrayOfWSGenericProperty $genericProperties = null)
    {
        if (is_null($genericProperties) || (is_array($genericProperties) && empty($genericProperties))) {
            unset($this->genericProperties);
        } else {
            $this->genericProperties = $genericProperties;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\WSEntryTerminal
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\WSEntryTerminal
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \StructType\WSEntryTerminal
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get parentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParentID()
    {
        return isset($this->parentID) ? $this->parentID : null;
    }
    /**
     * Set parentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parentID
     * @return \StructType\WSEntryTerminal
     */
    public function setParentID($parentID = null)
    {
        // validation for constraint: int
        if (!is_null($parentID) && !(is_int($parentID) || ctype_digit($parentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentID, true), gettype($parentID)), __LINE__);
        }
        if (is_null($parentID) || (is_array($parentID) && empty($parentID))) {
            unset($this->parentID);
        } else {
            $this->parentID = $parentID;
        }
        return $this;
    }
    /**
     * Get subTerminals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSEntryTerminal|null
     */
    public function getSubTerminals()
    {
        return isset($this->subTerminals) ? $this->subTerminals : null;
    }
    /**
     * Set subTerminals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSEntryTerminal $subTerminals
     * @return \StructType\WSEntryTerminal
     */
    public function setSubTerminals(\ArrayType\ArrayOfWSEntryTerminal $subTerminals = null)
    {
        if (is_null($subTerminals) || (is_array($subTerminals) && empty($subTerminals))) {
            unset($this->subTerminals);
        } else {
            $this->subTerminals = $subTerminals;
        }
        return $this;
    }
    /**
     * Get type value
     * @return int|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \StructType\WSEntryTerminal
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
