<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasicExtensibleObject StructType
 * @subpackage Structs
 */
class BasicExtensibleObject extends AbstractStructBase
{
    /**
     * The action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $action;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSExtension
     */
    public $extensions;
    /**
     * The genericProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSGenericProperty
     */
    public $genericProperties;
    /**
     * Constructor method for BasicExtensibleObject
     * @uses BasicExtensibleObject::setAction()
     * @uses BasicExtensibleObject::setExtensions()
     * @uses BasicExtensibleObject::setGenericProperties()
     * @param int $action
     * @param \ArrayType\ArrayOfWSExtension $extensions
     * @param \ArrayType\ArrayOfWSGenericProperty $genericProperties
     */
    public function __construct($action = null, \ArrayType\ArrayOfWSExtension $extensions = null, \ArrayType\ArrayOfWSGenericProperty $genericProperties = null)
    {
        $this
            ->setAction($action)
            ->setExtensions($extensions)
            ->setGenericProperties($genericProperties);
    }
    /**
     * Get action value
     * @return int|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param int $action
     * @return \StructType\BasicExtensibleObject
     */
    public function setAction($action = null)
    {
        // validation for constraint: int
        if (!is_null($action) && !(is_int($action) || ctype_digit($action))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSExtension|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSExtension $extensions
     * @return \StructType\BasicExtensibleObject
     */
    public function setExtensions(\ArrayType\ArrayOfWSExtension $extensions = null)
    {
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Get genericProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSGenericProperty|null
     */
    public function getGenericProperties()
    {
        return isset($this->genericProperties) ? $this->genericProperties : null;
    }
    /**
     * Set genericProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSGenericProperty $genericProperties
     * @return \StructType\BasicExtensibleObject
     */
    public function setGenericProperties(\ArrayType\ArrayOfWSGenericProperty $genericProperties = null)
    {
        if (is_null($genericProperties) || (is_array($genericProperties) && empty($genericProperties))) {
            unset($this->genericProperties);
        } else {
            $this->genericProperties = $genericProperties;
        }
        return $this;
    }
}
