<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSLinkedDuration ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSLinkedDuration extends AbstractStructArrayBase
{
    /**
     * The WSLinkedDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLinkedDuration[]
     */
    public $WSLinkedDuration;
    /**
     * Constructor method for ArrayOfWSLinkedDuration
     * @uses ArrayOfWSLinkedDuration::setWSLinkedDuration()
     * @param \StructType\WSLinkedDuration[] $wSLinkedDuration
     */
    public function __construct(array $wSLinkedDuration = array())
    {
        $this
            ->setWSLinkedDuration($wSLinkedDuration);
    }
    /**
     * Get WSLinkedDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLinkedDuration[]|null
     */
    public function getWSLinkedDuration()
    {
        return isset($this->WSLinkedDuration) ? $this->WSLinkedDuration : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSLinkedDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSLinkedDuration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSLinkedDurationForArrayConstraintsFromSetWSLinkedDuration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSLinkedDurationWSLinkedDurationItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSLinkedDurationWSLinkedDurationItem instanceof \StructType\WSLinkedDuration) {
                $invalidValues[] = is_object($arrayOfWSLinkedDurationWSLinkedDurationItem) ? get_class($arrayOfWSLinkedDurationWSLinkedDurationItem) : sprintf('%s(%s)', gettype($arrayOfWSLinkedDurationWSLinkedDurationItem), var_export($arrayOfWSLinkedDurationWSLinkedDurationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSLinkedDuration property can only contain items of type \StructType\WSLinkedDuration, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSLinkedDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSLinkedDuration[] $wSLinkedDuration
     * @return \ArrayType\ArrayOfWSLinkedDuration
     */
    public function setWSLinkedDuration(array $wSLinkedDuration = array())
    {
        // validation for constraint: array
        if ('' !== ($wSLinkedDurationArrayErrorMessage = self::validateWSLinkedDurationForArrayConstraintsFromSetWSLinkedDuration($wSLinkedDuration))) {
            throw new \InvalidArgumentException($wSLinkedDurationArrayErrorMessage, __LINE__);
        }
        if (is_null($wSLinkedDuration) || (is_array($wSLinkedDuration) && empty($wSLinkedDuration))) {
            unset($this->WSLinkedDuration);
        } else {
            $this->WSLinkedDuration = $wSLinkedDuration;
        }
        return $this;
    }
    /**
     * Add item to WSLinkedDuration value
     * @throws \InvalidArgumentException
     * @param \StructType\WSLinkedDuration $item
     * @return \ArrayType\ArrayOfWSLinkedDuration
     */
    public function addToWSLinkedDuration(\StructType\WSLinkedDuration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSLinkedDuration) {
            throw new \InvalidArgumentException(sprintf('The WSLinkedDuration property can only contain items of type \StructType\WSLinkedDuration, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSLinkedDuration[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSLinkedDuration|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSLinkedDuration|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSLinkedDuration|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSLinkedDuration|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSLinkedDuration|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSLinkedDuration
     */
    public function getAttributeName()
    {
        return 'WSLinkedDuration';
    }
}
