<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSLevelDefinition ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSLevelDefinition extends AbstractStructArrayBase
{
    /**
     * The WSLevelDefinition
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLevelDefinition[]
     */
    public $WSLevelDefinition;
    /**
     * Constructor method for ArrayOfWSLevelDefinition
     * @uses ArrayOfWSLevelDefinition::setWSLevelDefinition()
     * @param \StructType\WSLevelDefinition[] $wSLevelDefinition
     */
    public function __construct(array $wSLevelDefinition = array())
    {
        $this
            ->setWSLevelDefinition($wSLevelDefinition);
    }
    /**
     * Get WSLevelDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLevelDefinition[]|null
     */
    public function getWSLevelDefinition()
    {
        return isset($this->WSLevelDefinition) ? $this->WSLevelDefinition : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSLevelDefinition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSLevelDefinition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSLevelDefinitionForArrayConstraintsFromSetWSLevelDefinition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSLevelDefinitionWSLevelDefinitionItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSLevelDefinitionWSLevelDefinitionItem instanceof \StructType\WSLevelDefinition) {
                $invalidValues[] = is_object($arrayOfWSLevelDefinitionWSLevelDefinitionItem) ? get_class($arrayOfWSLevelDefinitionWSLevelDefinitionItem) : sprintf('%s(%s)', gettype($arrayOfWSLevelDefinitionWSLevelDefinitionItem), var_export($arrayOfWSLevelDefinitionWSLevelDefinitionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSLevelDefinition property can only contain items of type \StructType\WSLevelDefinition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSLevelDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSLevelDefinition[] $wSLevelDefinition
     * @return \ArrayType\ArrayOfWSLevelDefinition
     */
    public function setWSLevelDefinition(array $wSLevelDefinition = array())
    {
        // validation for constraint: array
        if ('' !== ($wSLevelDefinitionArrayErrorMessage = self::validateWSLevelDefinitionForArrayConstraintsFromSetWSLevelDefinition($wSLevelDefinition))) {
            throw new \InvalidArgumentException($wSLevelDefinitionArrayErrorMessage, __LINE__);
        }
        if (is_null($wSLevelDefinition) || (is_array($wSLevelDefinition) && empty($wSLevelDefinition))) {
            unset($this->WSLevelDefinition);
        } else {
            $this->WSLevelDefinition = $wSLevelDefinition;
        }
        return $this;
    }
    /**
     * Add item to WSLevelDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\WSLevelDefinition $item
     * @return \ArrayType\ArrayOfWSLevelDefinition
     */
    public function addToWSLevelDefinition(\StructType\WSLevelDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSLevelDefinition) {
            throw new \InvalidArgumentException(sprintf('The WSLevelDefinition property can only contain items of type \StructType\WSLevelDefinition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSLevelDefinition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSLevelDefinition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSLevelDefinition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSLevelDefinition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSLevelDefinition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSLevelDefinition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSLevelDefinition
     */
    public function getAttributeName()
    {
        return 'WSLevelDefinition';
    }
}
