<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSModificationError StructType
 * @subpackage Structs
 */
class WSModificationError extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $errorCode;
    /**
     * The errorText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $errorText;
    /**
     * The modification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $modification;
    /**
     * The objectId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $objectId;
    /**
     * Constructor method for WSModificationError
     * @uses WSModificationError::setErrorCode()
     * @uses WSModificationError::setErrorText()
     * @uses WSModificationError::setModification()
     * @uses WSModificationError::setObjectId()
     * @param int $errorCode
     * @param string $errorText
     * @param string $modification
     * @param int $objectId
     */
    public function __construct($errorCode = null, $errorText = null, $modification = null, $objectId = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorText($errorText)
            ->setModification($modification)
            ->setObjectId($objectId);
    }
    /**
     * Get errorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \StructType\WSModificationError
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorText()
    {
        return isset($this->errorText) ? $this->errorText : null;
    }
    /**
     * Set errorText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorText
     * @return \StructType\WSModificationError
     */
    public function setErrorText($errorText = null)
    {
        // validation for constraint: string
        if (!is_null($errorText) && !is_string($errorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorText, true), gettype($errorText)), __LINE__);
        }
        if (is_null($errorText) || (is_array($errorText) && empty($errorText))) {
            unset($this->errorText);
        } else {
            $this->errorText = $errorText;
        }
        return $this;
    }
    /**
     * Get modification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModification()
    {
        return isset($this->modification) ? $this->modification : null;
    }
    /**
     * Set modification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modification
     * @return \StructType\WSModificationError
     */
    public function setModification($modification = null)
    {
        // validation for constraint: string
        if (!is_null($modification) && !is_string($modification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modification, true), gettype($modification)), __LINE__);
        }
        if (is_null($modification) || (is_array($modification) && empty($modification))) {
            unset($this->modification);
        } else {
            $this->modification = $modification;
        }
        return $this;
    }
    /**
     * Get objectId value
     * @return int|null
     */
    public function getObjectId()
    {
        return $this->objectId;
    }
    /**
     * Set objectId value
     * @param int $objectId
     * @return \StructType\WSModificationError
     */
    public function setObjectId($objectId = null)
    {
        // validation for constraint: int
        if (!is_null($objectId) && !(is_int($objectId) || ctype_digit($objectId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectId, true), gettype($objectId)), __LINE__);
        }
        $this->objectId = $objectId;
        return $this;
    }
}
