<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSLink StructType
 * @subpackage Structs
 */
class WSLink extends AbstractStructBase
{
    /**
     * The action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $action;
    /**
     * The linkID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $linkID;
    /**
     * The linkType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $linkType;
    /**
     * The naturalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $naturalID;
    /**
     * The naturalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $naturalInfo;
    /**
     * Constructor method for WSLink
     * @uses WSLink::setAction()
     * @uses WSLink::setLinkID()
     * @uses WSLink::setLinkType()
     * @uses WSLink::setNaturalID()
     * @uses WSLink::setNaturalInfo()
     * @param int $action
     * @param int $linkID
     * @param int $linkType
     * @param string $naturalID
     * @param int $naturalInfo
     */
    public function __construct($action = null, $linkID = null, $linkType = null, $naturalID = null, $naturalInfo = null)
    {
        $this
            ->setAction($action)
            ->setLinkID($linkID)
            ->setLinkType($linkType)
            ->setNaturalID($naturalID)
            ->setNaturalInfo($naturalInfo);
    }
    /**
     * Get action value
     * @return int|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param int $action
     * @return \StructType\WSLink
     */
    public function setAction($action = null)
    {
        // validation for constraint: int
        if (!is_null($action) && !(is_int($action) || ctype_digit($action))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get linkID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLinkID()
    {
        return isset($this->linkID) ? $this->linkID : null;
    }
    /**
     * Set linkID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $linkID
     * @return \StructType\WSLink
     */
    public function setLinkID($linkID = null)
    {
        // validation for constraint: int
        if (!is_null($linkID) && !(is_int($linkID) || ctype_digit($linkID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkID, true), gettype($linkID)), __LINE__);
        }
        if (is_null($linkID) || (is_array($linkID) && empty($linkID))) {
            unset($this->linkID);
        } else {
            $this->linkID = $linkID;
        }
        return $this;
    }
    /**
     * Get linkType value
     * @return int|null
     */
    public function getLinkType()
    {
        return $this->linkType;
    }
    /**
     * Set linkType value
     * @param int $linkType
     * @return \StructType\WSLink
     */
    public function setLinkType($linkType = null)
    {
        // validation for constraint: int
        if (!is_null($linkType) && !(is_int($linkType) || ctype_digit($linkType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkType, true), gettype($linkType)), __LINE__);
        }
        $this->linkType = $linkType;
        return $this;
    }
    /**
     * Get naturalID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaturalID()
    {
        return isset($this->naturalID) ? $this->naturalID : null;
    }
    /**
     * Set naturalID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naturalID
     * @return \StructType\WSLink
     */
    public function setNaturalID($naturalID = null)
    {
        // validation for constraint: string
        if (!is_null($naturalID) && !is_string($naturalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naturalID, true), gettype($naturalID)), __LINE__);
        }
        if (is_null($naturalID) || (is_array($naturalID) && empty($naturalID))) {
            unset($this->naturalID);
        } else {
            $this->naturalID = $naturalID;
        }
        return $this;
    }
    /**
     * Get naturalInfo value
     * @return int|null
     */
    public function getNaturalInfo()
    {
        return $this->naturalInfo;
    }
    /**
     * Set naturalInfo value
     * @param int $naturalInfo
     * @return \StructType\WSLink
     */
    public function setNaturalInfo($naturalInfo = null)
    {
        // validation for constraint: int
        if (!is_null($naturalInfo) && !(is_int($naturalInfo) || ctype_digit($naturalInfo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($naturalInfo, true), gettype($naturalInfo)), __LINE__);
        }
        $this->naturalInfo = $naturalInfo;
        return $this;
    }
}
