<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSAddress StructType
 * @subpackage Structs
 */
class WSAddress extends AbstractStructBase
{
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $country;
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $latitude;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $longitude;
    /**
     * The postalcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $postalcode;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $street;
    /**
     * The streetnumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $streetnumber;
    /**
     * Constructor method for WSAddress
     * @uses WSAddress::setCity()
     * @uses WSAddress::setCountry()
     * @uses WSAddress::setLatitude()
     * @uses WSAddress::setLongitude()
     * @uses WSAddress::setPostalcode()
     * @uses WSAddress::setStreet()
     * @uses WSAddress::setStreetnumber()
     * @param string $city
     * @param string $country
     * @param int $latitude
     * @param int $longitude
     * @param int $postalcode
     * @param string $street
     * @param string $streetnumber
     */
    public function __construct($city = null, $country = null, $latitude = null, $longitude = null, $postalcode = null, $street = null, $streetnumber = null)
    {
        $this
            ->setCity($city)
            ->setCountry($country)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setPostalcode($postalcode)
            ->setStreet($street)
            ->setStreetnumber($streetnumber);
    }
    /**
     * Get city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->city) ? $this->city : null;
    }
    /**
     * Set city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\WSAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->city);
        } else {
            $this->city = $city;
        }
        return $this;
    }
    /**
     * Get country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->country) ? $this->country : null;
    }
    /**
     * Set country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \StructType\WSAddress
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->country);
        } else {
            $this->country = $country;
        }
        return $this;
    }
    /**
     * Get latitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLatitude()
    {
        return isset($this->latitude) ? $this->latitude : null;
    }
    /**
     * Set latitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $latitude
     * @return \StructType\WSAddress
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: int
        if (!is_null($latitude) && !(is_int($latitude) || ctype_digit($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        if (is_null($latitude) || (is_array($latitude) && empty($latitude))) {
            unset($this->latitude);
        } else {
            $this->latitude = $latitude;
        }
        return $this;
    }
    /**
     * Get longitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLongitude()
    {
        return isset($this->longitude) ? $this->longitude : null;
    }
    /**
     * Set longitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $longitude
     * @return \StructType\WSAddress
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: int
        if (!is_null($longitude) && !(is_int($longitude) || ctype_digit($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        if (is_null($longitude) || (is_array($longitude) && empty($longitude))) {
            unset($this->longitude);
        } else {
            $this->longitude = $longitude;
        }
        return $this;
    }
    /**
     * Get postalcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostalcode()
    {
        return isset($this->postalcode) ? $this->postalcode : null;
    }
    /**
     * Set postalcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postalcode
     * @return \StructType\WSAddress
     */
    public function setPostalcode($postalcode = null)
    {
        // validation for constraint: int
        if (!is_null($postalcode) && !(is_int($postalcode) || ctype_digit($postalcode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postalcode, true), gettype($postalcode)), __LINE__);
        }
        if (is_null($postalcode) || (is_array($postalcode) && empty($postalcode))) {
            unset($this->postalcode);
        } else {
            $this->postalcode = $postalcode;
        }
        return $this;
    }
    /**
     * Get street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreet()
    {
        return isset($this->street) ? $this->street : null;
    }
    /**
     * Set street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $street
     * @return \StructType\WSAddress
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->street);
        } else {
            $this->street = $street;
        }
        return $this;
    }
    /**
     * Get streetnumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetnumber()
    {
        return isset($this->streetnumber) ? $this->streetnumber : null;
    }
    /**
     * Set streetnumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetnumber
     * @return \StructType\WSAddress
     */
    public function setStreetnumber($streetnumber = null)
    {
        // validation for constraint: string
        if (!is_null($streetnumber) && !is_string($streetnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetnumber, true), gettype($streetnumber)), __LINE__);
        }
        if (is_null($streetnumber) || (is_array($streetnumber) && empty($streetnumber))) {
            unset($this->streetnumber);
        } else {
            $this->streetnumber = $streetnumber;
        }
        return $this;
    }
}
