<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSWaypoint StructType
 * @subpackage Structs
 */
class WSWaypoint extends AbstractStructBase
{
    /**
     * The direction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $direction;
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $latitude;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $longitude;
    /**
     * The positionTS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $positionTS;
    /**
     * The speed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $speed;
    /**
     * Constructor method for WSWaypoint
     * @uses WSWaypoint::setDirection()
     * @uses WSWaypoint::setLatitude()
     * @uses WSWaypoint::setLongitude()
     * @uses WSWaypoint::setPositionTS()
     * @uses WSWaypoint::setSpeed()
     * @param int $direction
     * @param int $latitude
     * @param int $longitude
     * @param \StructType\WSTimestamp $positionTS
     * @param int $speed
     */
    public function __construct($direction = null, $latitude = null, $longitude = null, \StructType\WSTimestamp $positionTS = null, $speed = null)
    {
        $this
            ->setDirection($direction)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setPositionTS($positionTS)
            ->setSpeed($speed);
    }
    /**
     * Get direction value
     * @return int|null
     */
    public function getDirection()
    {
        return $this->direction;
    }
    /**
     * Set direction value
     * @param int $direction
     * @return \StructType\WSWaypoint
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: int
        if (!is_null($direction) && !(is_int($direction) || ctype_digit($direction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($direction, true), gettype($direction)), __LINE__);
        }
        $this->direction = $direction;
        return $this;
    }
    /**
     * Get latitude value
     * @return int|null
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param int $latitude
     * @return \StructType\WSWaypoint
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: int
        if (!is_null($latitude) && !(is_int($latitude) || ctype_digit($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return int|null
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param int $longitude
     * @return \StructType\WSWaypoint
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: int
        if (!is_null($longitude) && !(is_int($longitude) || ctype_digit($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get positionTS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getPositionTS()
    {
        return isset($this->positionTS) ? $this->positionTS : null;
    }
    /**
     * Set positionTS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $positionTS
     * @return \StructType\WSWaypoint
     */
    public function setPositionTS(\StructType\WSTimestamp $positionTS = null)
    {
        if (is_null($positionTS) || (is_array($positionTS) && empty($positionTS))) {
            unset($this->positionTS);
        } else {
            $this->positionTS = $positionTS;
        }
        return $this;
    }
    /**
     * Get speed value
     * @return int|null
     */
    public function getSpeed()
    {
        return $this->speed;
    }
    /**
     * Set speed value
     * @param int $speed
     * @return \StructType\WSWaypoint
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !(is_int($speed) || ctype_digit($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->speed = $speed;
        return $this;
    }
}
