<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getAllVehicleStatuses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllVehicleStatuses $parameters
     * @return \StructType\GetAllVehicleStatusesResponse|bool
     */
    public function getAllVehicleStatuses(\StructType\GetAllVehicleStatuses $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllVehicleStatuses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLevelsByLevelID2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLevelsByLevelID2 $parameters
     * @return \StructType\GetLevelsByLevelID2Response|bool
     */
    public function getLevelsByLevelID2(\StructType\GetLevelsByLevelID2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLevelsByLevelID2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTerminalsByTypeE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTerminalsByTypeE $parameters
     * @return \StructType\GetTerminalsByTypeEResponse|bool
     */
    public function getTerminalsByTypeE(\StructType\GetTerminalsByTypeE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTerminalsByTypeE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCustomConfigurationForTerminalNr
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomConfigurationForTerminalNr $parameters
     * @return \StructType\GetCustomConfigurationForTerminalNrResponse|bool
     */
    public function getCustomConfigurationForTerminalNr(\StructType\GetCustomConfigurationForTerminalNr $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCustomConfigurationForTerminalNr($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGenericProperties
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGenericProperties $parameters
     * @return \StructType\GetGenericPropertiesResponse|bool
     */
    public function getGenericProperties(\StructType\GetGenericProperties $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getGenericProperties($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGroups $parameters
     * @return \StructType\GetGroupsResponse|bool
     */
    public function getGroups(\StructType\GetGroups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedBookingIDsByBookingTS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedBookingIDsByBookingTS $parameters
     * @return \StructType\GetDeletedBookingIDsByBookingTSResponse|bool
     */
    public function getDeletedBookingIDsByBookingTS(\StructType\GetDeletedBookingIDsByBookingTS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeletedBookingIDsByBookingTS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllPropertyDefinitions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllPropertyDefinitions $parameters
     * @return \StructType\GetAllPropertyDefinitionsResponse|bool
     */
    public function getAllPropertyDefinitions(\StructType\GetAllPropertyDefinitions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllPropertyDefinitions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLockDateByPersonDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLockDateByPersonDBID $parameters
     * @return \StructType\GetLockDateByPersonDBIDResponse|bool
     */
    public function getLockDateByPersonDBID(\StructType\GetLockDateByPersonDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLockDateByPersonDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountsByPersonDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountsByPersonDBID $parameters
     * @return \StructType\GetAccountsByPersonDBIDResponse|bool
     */
    public function getAccountsByPersonDBID(\StructType\GetAccountsByPersonDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountsByPersonDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTasksByChangeTS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTasksByChangeTS $parameters
     * @return \StructType\GetTasksByChangeTSResponse|bool
     */
    public function getTasksByChangeTS(\StructType\GetTasksByChangeTS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTasksByChangeTS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllBdeCustomPropertyDefinitions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllBdeCustomPropertyDefinitions $parameters
     * @return \StructType\GetAllBdeCustomPropertyDefinitionsResponse|bool
     */
    public function getAllBdeCustomPropertyDefinitions(\StructType\GetAllBdeCustomPropertyDefinitions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllBdeCustomPropertyDefinitions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCalendarEntriesByTimeRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCalendarEntriesByTimeRange $parameters
     * @return \StructType\GetCalendarEntriesByTimeRangeResponse|bool
     */
    public function getCalendarEntriesByTimeRange(\StructType\GetCalendarEntriesByTimeRange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCalendarEntriesByTimeRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLevelsByLevelID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLevelsByLevelID $parameters
     * @return \StructType\GetLevelsByLevelIDResponse|bool
     */
    public function getLevelsByLevelID(\StructType\GetLevelsByLevelID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLevelsByLevelID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getChangedForms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetChangedForms $parameters
     * @return \StructType\GetChangedFormsResponse|bool
     */
    public function getChangedForms(\StructType\GetChangedForms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getChangedForms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTime $parameters
     * @return \StructType\GetTimeResponse|bool
     */
    public function getTime(\StructType\GetTime $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTime($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFullDayAbsencesByPersonDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFullDayAbsencesByPersonDBID $parameters
     * @return \StructType\GetFullDayAbsencesByPersonDBIDResponse|bool
     */
    public function getFullDayAbsencesByPersonDBID(\StructType\GetFullDayAbsencesByPersonDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getFullDayAbsencesByPersonDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEntryTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEntryTerminal $parameters
     * @return \StructType\GetEntryTerminalResponse|bool
     */
    public function getEntryTerminal(\StructType\GetEntryTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEntryTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeletedBookingIDs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeletedBookingIDs $parameters
     * @return \StructType\GetDeletedBookingIDsResponse|bool
     */
    public function getDeletedBookingIDs(\StructType\GetDeletedBookingIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeletedBookingIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllAccountDefinitions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllAccountDefinitions $parameters
     * @return \StructType\GetAllAccountDefinitionsResponse|bool
     */
    public function getAllAccountDefinitions(\StructType\GetAllAccountDefinitions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllAccountDefinitions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountSumsForAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountSumsForAll $parameters
     * @return \StructType\GetAccountSumsForAllResponse|bool
     */
    public function getAccountSumsForAll(\StructType\GetAccountSumsForAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountSumsForAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPermissionsByDoorDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPermissionsByDoorDBID $parameters
     * @return \StructType\GetPermissionsByDoorDBIDResponse|bool
     */
    public function getPermissionsByDoorDBID(\StructType\GetPermissionsByDoorDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPermissionsByDoorDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountSumsByPersonID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountSumsByPersonID $parameters
     * @return \StructType\GetAccountSumsByPersonIDResponse|bool
     */
    public function getAccountSumsByPersonID(\StructType\GetAccountSumsByPersonID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountSumsByPersonID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomTerminalInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomTerminalInformation $parameters
     * @return \StructType\GetCustomTerminalInformationResponse|bool
     */
    public function getCustomTerminalInformation(\StructType\GetCustomTerminalInformation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCustomTerminalInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHoursByLevels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHoursByLevels $parameters
     * @return \StructType\GetHoursByLevelsResponse|bool
     */
    public function getHoursByLevels(\StructType\GetHoursByLevels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHoursByLevels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHoursByLevelDBIDs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHoursByLevelDBIDs $parameters
     * @return \StructType\GetHoursByLevelDBIDsResponse|bool
     */
    public function getHoursByLevelDBIDs(\StructType\GetHoursByLevelDBIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getHoursByLevelDBIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGroupMembershipsForMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGroupMembershipsForMember $parameters
     * @return \StructType\GetGroupMembershipsForMemberResponse|bool
     */
    public function getGroupMembershipsForMember(\StructType\GetGroupMembershipsForMember $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getGroupMembershipsForMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllGroups $parameters
     * @return \StructType\GetAllGroupsResponse|bool
     */
    public function getAllGroups(\StructType\GetAllGroups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStartDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStartDate $parameters
     * @return \StructType\GetStartDateResponse|bool
     */
    public function getStartDate(\StructType\GetStartDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getStartDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBookingPairsByLevelDBIDs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBookingPairsByLevelDBIDs $parameters
     * @return \StructType\GetBookingPairsByLevelDBIDsResponse|bool
     */
    public function getBookingPairsByLevelDBIDs(\StructType\GetBookingPairsByLevelDBIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingPairsByLevelDBIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTrips
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTrips $parameters
     * @return \StructType\GetTripsResponse|bool
     */
    public function getTrips(\StructType\GetTrips $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTrips($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSessionTimeout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSessionTimeout $parameters
     * @return \StructType\GetSessionTimeoutResponse|bool
     */
    public function getSessionTimeout(\StructType\GetSessionTimeout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSessionTimeout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLevelsEByIdentification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLevelsEByIdentification $parameters
     * @return \StructType\GetLevelsEByIdentificationResponse|bool
     */
    public function getLevelsEByIdentification(\StructType\GetLevelsEByIdentification $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLevelsEByIdentification($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getPersonsWithBookingChangesInRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPersonsWithBookingChangesInRange $parameters
     * @return \StructType\GetPersonsWithBookingChangesInRangeResponse|bool
     */
    public function getPersonsWithBookingChangesInRange(\StructType\GetPersonsWithBookingChangesInRange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPersonsWithBookingChangesInRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWaypointsOfVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWaypointsOfVehicle $parameters
     * @return \StructType\GetWaypointsOfVehicleResponse|bool
     */
    public function getWaypointsOfVehicle(\StructType\GetWaypointsOfVehicle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getWaypointsOfVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllVehicles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllVehicles $parameters
     * @return \StructType\GetAllVehiclesResponse|bool
     */
    public function getAllVehicles(\StructType\GetAllVehicles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllVehicles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllCustomers $parameters
     * @return \StructType\GetAllCustomersResponse|bool
     */
    public function getAllCustomers(\StructType\GetAllCustomers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEmployeesE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEmployeesE $parameters
     * @return \StructType\GetEmployeesEResponse|bool
     */
    public function getEmployeesE(\StructType\GetEmployeesE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEmployeesE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getChangedBDEBookingPairs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetChangedBDEBookingPairs $parameters
     * @return \StructType\GetChangedBDEBookingPairsResponse|bool
     */
    public function getChangedBDEBookingPairs(\StructType\GetChangedBDEBookingPairs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getChangedBDEBookingPairs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFullDayAbsencesByPersonID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFullDayAbsencesByPersonID $parameters
     * @return \StructType\GetFullDayAbsencesByPersonIDResponse|bool
     */
    public function getFullDayAbsencesByPersonID(\StructType\GetFullDayAbsencesByPersonID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getFullDayAbsencesByPersonID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getExceptionsByDoorDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExceptionsByDoorDBID $parameters
     * @return \StructType\GetExceptionsByDoorDBIDResponse|bool
     */
    public function getExceptionsByDoorDBID(\StructType\GetExceptionsByDoorDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getExceptionsByDoorDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountSumsByPersonID2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountSumsByPersonID2 $parameters
     * @return \StructType\GetAccountSumsByPersonID2Response|bool
     */
    public function getAccountSumsByPersonID2(\StructType\GetAccountSumsByPersonID2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountSumsByPersonID2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBookingPairsByLevels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBookingPairsByLevels $parameters
     * @return \StructType\GetBookingPairsByLevelsResponse|bool
     */
    public function getBookingPairsByLevels(\StructType\GetBookingPairsByLevels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingPairsByLevels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGroupsByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGroupsByName $parameters
     * @return \StructType\GetGroupsByNameResponse|bool
     */
    public function getGroupsByName(\StructType\GetGroupsByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getGroupsByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAttachedDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAttachedDocuments $parameters
     * @return \StructType\GetAttachedDocumentsResponse|bool
     */
    public function getAttachedDocuments(\StructType\GetAttachedDocuments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAttachedDocuments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccounts $parameters
     * @return \StructType\GetAccountsResponse|bool
     */
    public function getAccounts(\StructType\GetAccounts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGroupMemberships
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGroupMemberships $parameters
     * @return \StructType\GetGroupMembershipsResponse|bool
     */
    public function getGroupMemberships(\StructType\GetGroupMemberships $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getGroupMemberships($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTripsOfVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTripsOfVehicle $parameters
     * @return \StructType\GetTripsOfVehicleResponse|bool
     */
    public function getTripsOfVehicle(\StructType\GetTripsOfVehicle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTripsOfVehicle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGlobalLockDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGlobalLockDate $parameters
     * @return \StructType\GetGlobalLockDateResponse|bool
     */
    public function getGlobalLockDate(\StructType\GetGlobalLockDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getGlobalLockDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllEmployees
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllEmployees $parameters
     * @return \StructType\GetAllEmployeesResponse|bool
     */
    public function getAllEmployees(\StructType\GetAllEmployees $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllEmployees($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllTerminalsE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllTerminalsE $parameters
     * @return \StructType\GetAllTerminalsEResponse|bool
     */
    public function getAllTerminalsE(\StructType\GetAllTerminalsE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllTerminalsE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBookingPairs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBookingPairs $parameters
     * @return \StructType\GetBookingPairsResponse|bool
     */
    public function getBookingPairs(\StructType\GetBookingPairs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingPairs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCheckedBDEBookingPairs2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCheckedBDEBookingPairs2 $parameters
     * @return \StructType\GetCheckedBDEBookingPairs2Response|bool
     */
    public function getCheckedBDEBookingPairs2(\StructType\GetCheckedBDEBookingPairs2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCheckedBDEBookingPairs2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBookingPairsByPersonDBID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBookingPairsByPersonDBID $parameters
     * @return \StructType\GetBookingPairsByPersonDBIDResponse|bool
     */
    public function getBookingPairsByPersonDBID(\StructType\GetBookingPairsByPersonDBID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingPairsByPersonDBID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBookingPairsByPersonID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBookingPairsByPersonID $parameters
     * @return \StructType\GetBookingPairsByPersonIDResponse|bool
     */
    public function getBookingPairsByPersonID(\StructType\GetBookingPairsByPersonID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingPairsByPersonID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEntryPeriodDefinitionsById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEntryPeriodDefinitionsById $parameters
     * @return \StructType\GetEntryPeriodDefinitionsByIdResponse|bool
     */
    public function getEntryPeriodDefinitionsById(\StructType\GetEntryPeriodDefinitionsById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEntryPeriodDefinitionsById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllLevelDefinitions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllLevelDefinitions $parameters
     * @return \StructType\GetAllLevelDefinitionsResponse|bool
     */
    public function getAllLevelDefinitions(\StructType\GetAllLevelDefinitions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllLevelDefinitions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllCustomersE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllCustomersE $parameters
     * @return \StructType\GetAllCustomersEResponse|bool
     */
    public function getAllCustomersE(\StructType\GetAllCustomersE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllCustomersE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLevelsEByLevelID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLevelsEByLevelID $parameters
     * @return \StructType\GetLevelsEByLevelIDResponse|bool
     */
    public function getLevelsEByLevelID(\StructType\GetLevelsEByLevelID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLevelsEByLevelID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCheckedBDEBookingPairs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCheckedBDEBookingPairs $parameters
     * @return \StructType\GetCheckedBDEBookingPairsResponse|bool
     */
    public function getCheckedBDEBookingPairs(\StructType\GetCheckedBDEBookingPairs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getCheckedBDEBookingPairs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllEmployeesE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllEmployeesE $parameters
     * @return \StructType\GetAllEmployeesEResponse|bool
     */
    public function getAllEmployeesE(\StructType\GetAllEmployeesE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllEmployeesE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountSums
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountSums $parameters
     * @return \StructType\GetAccountSumsResponse|bool
     */
    public function getAccountSums(\StructType\GetAccountSums $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountSums($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllPersons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllPersons $parameters
     * @return \StructType\GetAllPersonsResponse|bool
     */
    public function getAllPersons(\StructType\GetAllPersons $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllPersons($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLockDateByPersonID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLockDateByPersonID $parameters
     * @return \StructType\GetLockDateByPersonIDResponse|bool
     */
    public function getLockDateByPersonID(\StructType\GetLockDateByPersonID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLockDateByPersonID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLevelByIdentification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLevelByIdentification $parameters
     * @return \StructType\GetLevelByIdentificationResponse|bool
     */
    public function getLevelByIdentification(\StructType\GetLevelByIdentification $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLevelByIdentification($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountsByPersonID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountsByPersonID $parameters
     * @return \StructType\GetAccountsByPersonIDResponse|bool
     */
    public function getAccountsByPersonID(\StructType\GetAccountsByPersonID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAccountsByPersonID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBookingPairsByLevel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBookingPairsByLevel $parameters
     * @return \StructType\GetBookingPairsByLevelResponse|bool
     */
    public function getBookingPairsByLevel(\StructType\GetBookingPairsByLevel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingPairsByLevel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTask
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTask $parameters
     * @return \StructType\GetTaskResponse|bool
     */
    public function getTask(\StructType\GetTask $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTask($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLevelsByIdentification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLevelsByIdentification $parameters
     * @return \StructType\GetLevelsByIdentificationResponse|bool
     */
    public function getLevelsByIdentification(\StructType\GetLevelsByIdentification $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLevelsByIdentification($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTrips2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTrips2 $parameters
     * @return \StructType\GetTrips2Response|bool
     */
    public function getTrips2(\StructType\GetTrips2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTrips2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountsByPersonDBIDResponse|\StructType\GetAccountsByPersonIDResponse|\StructType\GetAccountsResponse|\StructType\GetAccountSumsByPersonID2Response|\StructType\GetAccountSumsByPersonIDResponse|\StructType\GetAccountSumsForAllResponse|\StructType\GetAccountSumsResponse|\StructType\GetAllAccountDefinitionsResponse|\StructType\GetAllBdeCustomPropertyDefinitionsResponse|\StructType\GetAllCustomersEResponse|\StructType\GetAllCustomersResponse|\StructType\GetAllEmployeesEResponse|\StructType\GetAllEmployeesResponse|\StructType\GetAllGroupsResponse|\StructType\GetAllLevelDefinitionsResponse|\StructType\GetAllPersonsResponse|\StructType\GetAllPropertyDefinitionsResponse|\StructType\GetAllTerminalsEResponse|\StructType\GetAllVehiclesResponse|\StructType\GetAllVehicleStatusesResponse|\StructType\GetAttachedDocumentsResponse|\StructType\GetBookingPairsByLevelDBIDsResponse|\StructType\GetBookingPairsByLevelResponse|\StructType\GetBookingPairsByLevelsResponse|\StructType\GetBookingPairsByPersonDBIDResponse|\StructType\GetBookingPairsByPersonIDResponse|\StructType\GetBookingPairsResponse|\StructType\GetCalendarEntriesByTimeRangeResponse|\StructType\GetChangedBDEBookingPairsResponse|\StructType\GetChangedFormsResponse|\StructType\GetCheckedBDEBookingPairs2Response|\StructType\GetCheckedBDEBookingPairsResponse|\StructType\GetCustomConfigurationForTerminalNrResponse|\StructType\GetCustomTerminalInformationResponse|\StructType\GetDeletedBookingIDsByBookingTSResponse|\StructType\GetDeletedBookingIDsResponse|\StructType\GetEmployeesEResponse|\StructType\GetEntryPeriodDefinitionsByIdResponse|\StructType\GetEntryTerminalResponse|\StructType\GetExceptionsByDoorDBIDResponse|\StructType\GetFullDayAbsencesByPersonDBIDResponse|\StructType\GetFullDayAbsencesByPersonIDResponse|\StructType\GetGenericPropertiesResponse|\StructType\GetGlobalLockDateResponse|\StructType\GetGroupMembershipsForMemberResponse|\StructType\GetGroupMembershipsResponse|\StructType\GetGroupsByNameResponse|\StructType\GetGroupsResponse|\StructType\GetHoursByLevelDBIDsResponse|\StructType\GetHoursByLevelsResponse|\StructType\GetLevelByIdentificationResponse|\StructType\GetLevelsByIdentificationResponse|\StructType\GetLevelsByLevelID2Response|\StructType\GetLevelsByLevelIDResponse|\StructType\GetLevelsEByIdentificationResponse|\StructType\GetLevelsEByLevelIDResponse|\StructType\GetLockDateByPersonDBIDResponse|\StructType\GetLockDateByPersonIDResponse|\StructType\GetPermissionsByDoorDBIDResponse|\StructType\GetPersonsWithBookingChangesInRangeResponse|\StructType\GetSessionTimeoutResponse|\StructType\GetStartDateResponse|\StructType\GetTaskResponse|\StructType\GetTasksByChangeTSResponse|\StructType\GetTerminalsByTypeEResponse|\StructType\GetTimeResponse|\StructType\GetTrips2Response|\StructType\GetTripsOfVehicleResponse|\StructType\GetTripsResponse|\StructType\GetWaypointsOfVehicleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
