<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSCustomTerminalInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSCustomTerminalInfo extends AbstractStructArrayBase
{
    /**
     * The WSCustomTerminalInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSCustomTerminalInfo[]
     */
    public $WSCustomTerminalInfo;
    /**
     * Constructor method for ArrayOfWSCustomTerminalInfo
     * @uses ArrayOfWSCustomTerminalInfo::setWSCustomTerminalInfo()
     * @param \StructType\WSCustomTerminalInfo[] $wSCustomTerminalInfo
     */
    public function __construct(array $wSCustomTerminalInfo = array())
    {
        $this
            ->setWSCustomTerminalInfo($wSCustomTerminalInfo);
    }
    /**
     * Get WSCustomTerminalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSCustomTerminalInfo[]|null
     */
    public function getWSCustomTerminalInfo()
    {
        return isset($this->WSCustomTerminalInfo) ? $this->WSCustomTerminalInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSCustomTerminalInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSCustomTerminalInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSCustomTerminalInfoForArrayConstraintsFromSetWSCustomTerminalInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSCustomTerminalInfoWSCustomTerminalInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSCustomTerminalInfoWSCustomTerminalInfoItem instanceof \StructType\WSCustomTerminalInfo) {
                $invalidValues[] = is_object($arrayOfWSCustomTerminalInfoWSCustomTerminalInfoItem) ? get_class($arrayOfWSCustomTerminalInfoWSCustomTerminalInfoItem) : sprintf('%s(%s)', gettype($arrayOfWSCustomTerminalInfoWSCustomTerminalInfoItem), var_export($arrayOfWSCustomTerminalInfoWSCustomTerminalInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSCustomTerminalInfo property can only contain items of type \StructType\WSCustomTerminalInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSCustomTerminalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSCustomTerminalInfo[] $wSCustomTerminalInfo
     * @return \ArrayType\ArrayOfWSCustomTerminalInfo
     */
    public function setWSCustomTerminalInfo(array $wSCustomTerminalInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($wSCustomTerminalInfoArrayErrorMessage = self::validateWSCustomTerminalInfoForArrayConstraintsFromSetWSCustomTerminalInfo($wSCustomTerminalInfo))) {
            throw new \InvalidArgumentException($wSCustomTerminalInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($wSCustomTerminalInfo) || (is_array($wSCustomTerminalInfo) && empty($wSCustomTerminalInfo))) {
            unset($this->WSCustomTerminalInfo);
        } else {
            $this->WSCustomTerminalInfo = $wSCustomTerminalInfo;
        }
        return $this;
    }
    /**
     * Add item to WSCustomTerminalInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\WSCustomTerminalInfo $item
     * @return \ArrayType\ArrayOfWSCustomTerminalInfo
     */
    public function addToWSCustomTerminalInfo(\StructType\WSCustomTerminalInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSCustomTerminalInfo) {
            throw new \InvalidArgumentException(sprintf('The WSCustomTerminalInfo property can only contain items of type \StructType\WSCustomTerminalInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSCustomTerminalInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSCustomTerminalInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSCustomTerminalInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSCustomTerminalInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSCustomTerminalInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSCustomTerminalInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSCustomTerminalInfo
     */
    public function getAttributeName()
    {
        return 'WSCustomTerminalInfo';
    }
}
