<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSProperty StructType
 * @subpackage Structs
 */
class WSProperty extends AbstractStructBase
{
    /**
     * The key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $key;
    /**
     * The val
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $val;
    /**
     * Constructor method for WSProperty
     * @uses WSProperty::setKey()
     * @uses WSProperty::setVal()
     * @param int $key
     * @param string $val
     */
    public function __construct($key = null, $val = null)
    {
        $this
            ->setKey($key)
            ->setVal($val);
    }
    /**
     * Get key value
     * @return int|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param int $key
     * @return \StructType\WSProperty
     */
    public function setKey($key = null)
    {
        // validation for constraint: int
        if (!is_null($key) && !(is_int($key) || ctype_digit($key))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get val value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVal()
    {
        return isset($this->val) ? $this->val : null;
    }
    /**
     * Set val value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $val
     * @return \StructType\WSProperty
     */
    public function setVal($val = null)
    {
        // validation for constraint: string
        if (!is_null($val) && !is_string($val)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($val, true), gettype($val)), __LINE__);
        }
        if (is_null($val) || (is_array($val) && empty($val))) {
            unset($this->val);
        } else {
            $this->val = $val;
        }
        return $this;
    }
}
