<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSBulkAccountCorrection ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSBulkAccountCorrection extends AbstractStructArrayBase
{
    /**
     * The WSBulkAccountCorrection
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSBulkAccountCorrection[]
     */
    public $WSBulkAccountCorrection;
    /**
     * Constructor method for ArrayOfWSBulkAccountCorrection
     * @uses ArrayOfWSBulkAccountCorrection::setWSBulkAccountCorrection()
     * @param \StructType\WSBulkAccountCorrection[] $wSBulkAccountCorrection
     */
    public function __construct(array $wSBulkAccountCorrection = array())
    {
        $this
            ->setWSBulkAccountCorrection($wSBulkAccountCorrection);
    }
    /**
     * Get WSBulkAccountCorrection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSBulkAccountCorrection[]|null
     */
    public function getWSBulkAccountCorrection()
    {
        return isset($this->WSBulkAccountCorrection) ? $this->WSBulkAccountCorrection : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSBulkAccountCorrection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSBulkAccountCorrection method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSBulkAccountCorrectionForArrayConstraintsFromSetWSBulkAccountCorrection(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSBulkAccountCorrectionWSBulkAccountCorrectionItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSBulkAccountCorrectionWSBulkAccountCorrectionItem instanceof \StructType\WSBulkAccountCorrection) {
                $invalidValues[] = is_object($arrayOfWSBulkAccountCorrectionWSBulkAccountCorrectionItem) ? get_class($arrayOfWSBulkAccountCorrectionWSBulkAccountCorrectionItem) : sprintf('%s(%s)', gettype($arrayOfWSBulkAccountCorrectionWSBulkAccountCorrectionItem), var_export($arrayOfWSBulkAccountCorrectionWSBulkAccountCorrectionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSBulkAccountCorrection property can only contain items of type \StructType\WSBulkAccountCorrection, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSBulkAccountCorrection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSBulkAccountCorrection[] $wSBulkAccountCorrection
     * @return \ArrayType\ArrayOfWSBulkAccountCorrection
     */
    public function setWSBulkAccountCorrection(array $wSBulkAccountCorrection = array())
    {
        // validation for constraint: array
        if ('' !== ($wSBulkAccountCorrectionArrayErrorMessage = self::validateWSBulkAccountCorrectionForArrayConstraintsFromSetWSBulkAccountCorrection($wSBulkAccountCorrection))) {
            throw new \InvalidArgumentException($wSBulkAccountCorrectionArrayErrorMessage, __LINE__);
        }
        if (is_null($wSBulkAccountCorrection) || (is_array($wSBulkAccountCorrection) && empty($wSBulkAccountCorrection))) {
            unset($this->WSBulkAccountCorrection);
        } else {
            $this->WSBulkAccountCorrection = $wSBulkAccountCorrection;
        }
        return $this;
    }
    /**
     * Add item to WSBulkAccountCorrection value
     * @throws \InvalidArgumentException
     * @param \StructType\WSBulkAccountCorrection $item
     * @return \ArrayType\ArrayOfWSBulkAccountCorrection
     */
    public function addToWSBulkAccountCorrection(\StructType\WSBulkAccountCorrection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSBulkAccountCorrection) {
            throw new \InvalidArgumentException(sprintf('The WSBulkAccountCorrection property can only contain items of type \StructType\WSBulkAccountCorrection, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSBulkAccountCorrection[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSBulkAccountCorrection|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSBulkAccountCorrection|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSBulkAccountCorrection|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSBulkAccountCorrection|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSBulkAccountCorrection|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSBulkAccountCorrection
     */
    public function getAttributeName()
    {
        return 'WSBulkAccountCorrection';
    }
}
