<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSTrip2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSTrip2 extends AbstractStructArrayBase
{
    /**
     * The WSTrip2
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTrip2[]
     */
    public $WSTrip2;
    /**
     * Constructor method for ArrayOfWSTrip2
     * @uses ArrayOfWSTrip2::setWSTrip2()
     * @param \StructType\WSTrip2[] $wSTrip2
     */
    public function __construct(array $wSTrip2 = array())
    {
        $this
            ->setWSTrip2($wSTrip2);
    }
    /**
     * Get WSTrip2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTrip2[]|null
     */
    public function getWSTrip2()
    {
        return isset($this->WSTrip2) ? $this->WSTrip2 : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSTrip2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSTrip2 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSTrip2ForArrayConstraintsFromSetWSTrip2(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSTrip2WSTrip2Item) {
            // validation for constraint: itemType
            if (!$arrayOfWSTrip2WSTrip2Item instanceof \StructType\WSTrip2) {
                $invalidValues[] = is_object($arrayOfWSTrip2WSTrip2Item) ? get_class($arrayOfWSTrip2WSTrip2Item) : sprintf('%s(%s)', gettype($arrayOfWSTrip2WSTrip2Item), var_export($arrayOfWSTrip2WSTrip2Item, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSTrip2 property can only contain items of type \StructType\WSTrip2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSTrip2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSTrip2[] $wSTrip2
     * @return \ArrayType\ArrayOfWSTrip2
     */
    public function setWSTrip2(array $wSTrip2 = array())
    {
        // validation for constraint: array
        if ('' !== ($wSTrip2ArrayErrorMessage = self::validateWSTrip2ForArrayConstraintsFromSetWSTrip2($wSTrip2))) {
            throw new \InvalidArgumentException($wSTrip2ArrayErrorMessage, __LINE__);
        }
        if (is_null($wSTrip2) || (is_array($wSTrip2) && empty($wSTrip2))) {
            unset($this->WSTrip2);
        } else {
            $this->WSTrip2 = $wSTrip2;
        }
        return $this;
    }
    /**
     * Add item to WSTrip2 value
     * @throws \InvalidArgumentException
     * @param \StructType\WSTrip2 $item
     * @return \ArrayType\ArrayOfWSTrip2
     */
    public function addToWSTrip2(\StructType\WSTrip2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSTrip2) {
            throw new \InvalidArgumentException(sprintf('The WSTrip2 property can only contain items of type \StructType\WSTrip2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSTrip2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSTrip2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSTrip2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSTrip2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSTrip2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSTrip2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSTrip2
     */
    public function getAttributeName()
    {
        return 'WSTrip2';
    }
}
