<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSTrip ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSTrip extends AbstractStructArrayBase
{
    /**
     * The WSTrip
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTrip[]
     */
    public $WSTrip;
    /**
     * Constructor method for ArrayOfWSTrip
     * @uses ArrayOfWSTrip::setWSTrip()
     * @param \StructType\WSTrip[] $wSTrip
     */
    public function __construct(array $wSTrip = array())
    {
        $this
            ->setWSTrip($wSTrip);
    }
    /**
     * Get WSTrip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTrip[]|null
     */
    public function getWSTrip()
    {
        return isset($this->WSTrip) ? $this->WSTrip : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSTrip method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSTrip method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSTripForArrayConstraintsFromSetWSTrip(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSTripWSTripItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSTripWSTripItem instanceof \StructType\WSTrip) {
                $invalidValues[] = is_object($arrayOfWSTripWSTripItem) ? get_class($arrayOfWSTripWSTripItem) : sprintf('%s(%s)', gettype($arrayOfWSTripWSTripItem), var_export($arrayOfWSTripWSTripItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSTrip property can only contain items of type \StructType\WSTrip, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSTrip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSTrip[] $wSTrip
     * @return \ArrayType\ArrayOfWSTrip
     */
    public function setWSTrip(array $wSTrip = array())
    {
        // validation for constraint: array
        if ('' !== ($wSTripArrayErrorMessage = self::validateWSTripForArrayConstraintsFromSetWSTrip($wSTrip))) {
            throw new \InvalidArgumentException($wSTripArrayErrorMessage, __LINE__);
        }
        if (is_null($wSTrip) || (is_array($wSTrip) && empty($wSTrip))) {
            unset($this->WSTrip);
        } else {
            $this->WSTrip = $wSTrip;
        }
        return $this;
    }
    /**
     * Add item to WSTrip value
     * @throws \InvalidArgumentException
     * @param \StructType\WSTrip $item
     * @return \ArrayType\ArrayOfWSTrip
     */
    public function addToWSTrip(\StructType\WSTrip $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSTrip) {
            throw new \InvalidArgumentException(sprintf('The WSTrip property can only contain items of type \StructType\WSTrip, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSTrip[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSTrip|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSTrip|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSTrip|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSTrip|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSTrip|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSTrip
     */
    public function getAttributeName()
    {
        return 'WSTrip';
    }
}
