<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Clear ServiceType
 * @subpackage Services
 */
class Clear extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named clearSessionOption
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ClearSessionOption $parameters
     * @return \StructType\ClearSessionOptionResponse|bool
     */
    public function clearSessionOption(\StructType\ClearSessionOption $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->clearSessionOption($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ClearSessionOptionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
