<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTerminalBooking2 StructType
 * @subpackage Structs
 */
class WSTerminalBooking2 extends AbstractStructBase
{
    /**
     * The bookingData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bookingData;
    /**
     * The terminalType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $terminalType;
    /**
     * The terminalid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $terminalid;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $timestamp;
    /**
     * Constructor method for WSTerminalBooking2
     * @uses WSTerminalBooking2::setBookingData()
     * @uses WSTerminalBooking2::setTerminalType()
     * @uses WSTerminalBooking2::setTerminalid()
     * @uses WSTerminalBooking2::setTimestamp()
     * @param string $bookingData
     * @param int $terminalType
     * @param int $terminalid
     * @param \StructType\WSTimestamp $timestamp
     */
    public function __construct($bookingData = null, $terminalType = null, $terminalid = null, \StructType\WSTimestamp $timestamp = null)
    {
        $this
            ->setBookingData($bookingData)
            ->setTerminalType($terminalType)
            ->setTerminalid($terminalid)
            ->setTimestamp($timestamp);
    }
    /**
     * Get bookingData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingData()
    {
        return isset($this->bookingData) ? $this->bookingData : null;
    }
    /**
     * Set bookingData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingData
     * @return \StructType\WSTerminalBooking2
     */
    public function setBookingData($bookingData = null)
    {
        // validation for constraint: string
        if (!is_null($bookingData) && !is_string($bookingData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingData, true), gettype($bookingData)), __LINE__);
        }
        if (is_null($bookingData) || (is_array($bookingData) && empty($bookingData))) {
            unset($this->bookingData);
        } else {
            $this->bookingData = $bookingData;
        }
        return $this;
    }
    /**
     * Get terminalType value
     * @return int|null
     */
    public function getTerminalType()
    {
        return $this->terminalType;
    }
    /**
     * Set terminalType value
     * @param int $terminalType
     * @return \StructType\WSTerminalBooking2
     */
    public function setTerminalType($terminalType = null)
    {
        // validation for constraint: int
        if (!is_null($terminalType) && !(is_int($terminalType) || ctype_digit($terminalType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalType, true), gettype($terminalType)), __LINE__);
        }
        $this->terminalType = $terminalType;
        return $this;
    }
    /**
     * Get terminalid value
     * @return int|null
     */
    public function getTerminalid()
    {
        return $this->terminalid;
    }
    /**
     * Set terminalid value
     * @param int $terminalid
     * @return \StructType\WSTerminalBooking2
     */
    public function setTerminalid($terminalid = null)
    {
        // validation for constraint: int
        if (!is_null($terminalid) && !(is_int($terminalid) || ctype_digit($terminalid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalid, true), gettype($terminalid)), __LINE__);
        }
        $this->terminalid = $terminalid;
        return $this;
    }
    /**
     * Get timestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getTimestamp()
    {
        return isset($this->timestamp) ? $this->timestamp : null;
    }
    /**
     * Set timestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $timestamp
     * @return \StructType\WSTerminalBooking2
     */
    public function setTimestamp(\StructType\WSTimestamp $timestamp = null)
    {
        if (is_null($timestamp) || (is_array($timestamp) && empty($timestamp))) {
            unset($this->timestamp);
        } else {
            $this->timestamp = $timestamp;
        }
        return $this;
    }
}
