<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSPosition StructType
 * @subpackage Structs
 */
class WSPosition extends AbstractStructBase
{
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $city;
    /**
     * The customerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $customerID;
    /**
     * The lat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lat;
    /**
     * The lon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lon;
    /**
     * The odometer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $odometer;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postalCode;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $street;
    /**
     * The ts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $ts;
    /**
     * Constructor method for WSPosition
     * @uses WSPosition::setCity()
     * @uses WSPosition::setCustomerID()
     * @uses WSPosition::setLat()
     * @uses WSPosition::setLon()
     * @uses WSPosition::setOdometer()
     * @uses WSPosition::setPostalCode()
     * @uses WSPosition::setStreet()
     * @uses WSPosition::setTs()
     * @param string $city
     * @param int $customerID
     * @param int $lat
     * @param int $lon
     * @param int $odometer
     * @param string $postalCode
     * @param string $street
     * @param \StructType\WSTimestamp $ts
     */
    public function __construct($city = null, $customerID = null, $lat = null, $lon = null, $odometer = null, $postalCode = null, $street = null, \StructType\WSTimestamp $ts = null)
    {
        $this
            ->setCity($city)
            ->setCustomerID($customerID)
            ->setLat($lat)
            ->setLon($lon)
            ->setOdometer($odometer)
            ->setPostalCode($postalCode)
            ->setStreet($street)
            ->setTs($ts);
    }
    /**
     * Get city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->city) ? $this->city : null;
    }
    /**
     * Set city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\WSPosition
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->city);
        } else {
            $this->city = $city;
        }
        return $this;
    }
    /**
     * Get customerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->customerID;
    }
    /**
     * Set customerID value
     * @param int $customerID
     * @return \StructType\WSPosition
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->customerID = $customerID;
        return $this;
    }
    /**
     * Get lat value
     * @return int|null
     */
    public function getLat()
    {
        return $this->lat;
    }
    /**
     * Set lat value
     * @param int $lat
     * @return \StructType\WSPosition
     */
    public function setLat($lat = null)
    {
        // validation for constraint: int
        if (!is_null($lat) && !(is_int($lat) || ctype_digit($lat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lat, true), gettype($lat)), __LINE__);
        }
        $this->lat = $lat;
        return $this;
    }
    /**
     * Get lon value
     * @return int|null
     */
    public function getLon()
    {
        return $this->lon;
    }
    /**
     * Set lon value
     * @param int $lon
     * @return \StructType\WSPosition
     */
    public function setLon($lon = null)
    {
        // validation for constraint: int
        if (!is_null($lon) && !(is_int($lon) || ctype_digit($lon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lon, true), gettype($lon)), __LINE__);
        }
        $this->lon = $lon;
        return $this;
    }
    /**
     * Get odometer value
     * @return int|null
     */
    public function getOdometer()
    {
        return $this->odometer;
    }
    /**
     * Set odometer value
     * @param int $odometer
     * @return \StructType\WSPosition
     */
    public function setOdometer($odometer = null)
    {
        // validation for constraint: int
        if (!is_null($odometer) && !(is_int($odometer) || ctype_digit($odometer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($odometer, true), gettype($odometer)), __LINE__);
        }
        $this->odometer = $odometer;
        return $this;
    }
    /**
     * Get postalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostalCode()
    {
        return isset($this->postalCode) ? $this->postalCode : null;
    }
    /**
     * Set postalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postalCode
     * @return \StructType\WSPosition
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        if (is_null($postalCode) || (is_array($postalCode) && empty($postalCode))) {
            unset($this->postalCode);
        } else {
            $this->postalCode = $postalCode;
        }
        return $this;
    }
    /**
     * Get street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreet()
    {
        return isset($this->street) ? $this->street : null;
    }
    /**
     * Set street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $street
     * @return \StructType\WSPosition
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->street);
        } else {
            $this->street = $street;
        }
        return $this;
    }
    /**
     * Get ts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getTs()
    {
        return isset($this->ts) ? $this->ts : null;
    }
    /**
     * Set ts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $ts
     * @return \StructType\WSPosition
     */
    public function setTs(\StructType\WSTimestamp $ts = null)
    {
        if (is_null($ts) || (is_array($ts) && empty($ts))) {
            unset($this->ts);
        } else {
            $this->ts = $ts;
        }
        return $this;
    }
}
