<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSEntryPeriodDefinition StructType
 * @subpackage Structs
 */
class WSEntryPeriodDefinition extends AbstractStructBase
{
    /**
     * The days
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSEntryPeriodDay
     */
    public $days;
    /**
     * The flags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $flags;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * Constructor method for WSEntryPeriodDefinition
     * @uses WSEntryPeriodDefinition::setDays()
     * @uses WSEntryPeriodDefinition::setFlags()
     * @uses WSEntryPeriodDefinition::setId()
     * @uses WSEntryPeriodDefinition::setName()
     * @param \ArrayType\ArrayOfWSEntryPeriodDay $days
     * @param \ArrayType\ArrayOfWSKeyValue $flags
     * @param int $id
     * @param string $name
     */
    public function __construct(\ArrayType\ArrayOfWSEntryPeriodDay $days = null, \ArrayType\ArrayOfWSKeyValue $flags = null, $id = null, $name = null)
    {
        $this
            ->setDays($days)
            ->setFlags($flags)
            ->setId($id)
            ->setName($name);
    }
    /**
     * Get days value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSEntryPeriodDay|null
     */
    public function getDays()
    {
        return isset($this->days) ? $this->days : null;
    }
    /**
     * Set days value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSEntryPeriodDay $days
     * @return \StructType\WSEntryPeriodDefinition
     */
    public function setDays(\ArrayType\ArrayOfWSEntryPeriodDay $days = null)
    {
        if (is_null($days) || (is_array($days) && empty($days))) {
            unset($this->days);
        } else {
            $this->days = $days;
        }
        return $this;
    }
    /**
     * Get flags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getFlags()
    {
        return isset($this->flags) ? $this->flags : null;
    }
    /**
     * Set flags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $flags
     * @return \StructType\WSEntryPeriodDefinition
     */
    public function setFlags(\ArrayType\ArrayOfWSKeyValue $flags = null)
    {
        if (is_null($flags) || (is_array($flags) && empty($flags))) {
            unset($this->flags);
        } else {
            $this->flags = $flags;
        }
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\WSEntryPeriodDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\WSEntryPeriodDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
}
