<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTask StructType
 * @subpackage Structs
 */
class WSTask extends AbstractStructBase
{
    /**
     * The action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $action;
    /**
     * The appointment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $appointment;
    /**
     * The durationMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $durationMinutes;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSExtension
     */
    public $extensions;
    /**
     * The flowId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $flowId;
    /**
     * The genericProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSGenericProperty
     */
    public $genericProperties;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The lastChangeTs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $lastChangeTs;
    /**
     * The lastHistoryTs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $lastHistoryTs;
    /**
     * The recipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSTaskRecipient
     */
    public $recipients;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLink
     */
    public $sender;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $state;
    /**
     * The stepId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $stepId;
    /**
     * The text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $text;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $type;
    /**
     * Constructor method for WSTask
     * @uses WSTask::setAction()
     * @uses WSTask::setAppointment()
     * @uses WSTask::setDurationMinutes()
     * @uses WSTask::setExtensions()
     * @uses WSTask::setFlowId()
     * @uses WSTask::setGenericProperties()
     * @uses WSTask::setId()
     * @uses WSTask::setLastChangeTs()
     * @uses WSTask::setLastHistoryTs()
     * @uses WSTask::setRecipients()
     * @uses WSTask::setSender()
     * @uses WSTask::setState()
     * @uses WSTask::setStepId()
     * @uses WSTask::setText()
     * @uses WSTask::setType()
     * @param int $action
     * @param \StructType\WSTimestamp $appointment
     * @param int $durationMinutes
     * @param \ArrayType\ArrayOfWSExtension $extensions
     * @param int $flowId
     * @param \ArrayType\ArrayOfWSGenericProperty $genericProperties
     * @param int $id
     * @param \StructType\WSTimestamp $lastChangeTs
     * @param \StructType\WSTimestamp $lastHistoryTs
     * @param \ArrayType\ArrayOfWSTaskRecipient $recipients
     * @param \StructType\WSLink $sender
     * @param string $state
     * @param int $stepId
     * @param string $text
     * @param string $type
     */
    public function __construct($action = null, \StructType\WSTimestamp $appointment = null, $durationMinutes = null, \ArrayType\ArrayOfWSExtension $extensions = null, $flowId = null, \ArrayType\ArrayOfWSGenericProperty $genericProperties = null, $id = null, \StructType\WSTimestamp $lastChangeTs = null, \StructType\WSTimestamp $lastHistoryTs = null, \ArrayType\ArrayOfWSTaskRecipient $recipients = null, \StructType\WSLink $sender = null, $state = null, $stepId = null, $text = null, $type = null)
    {
        $this
            ->setAction($action)
            ->setAppointment($appointment)
            ->setDurationMinutes($durationMinutes)
            ->setExtensions($extensions)
            ->setFlowId($flowId)
            ->setGenericProperties($genericProperties)
            ->setId($id)
            ->setLastChangeTs($lastChangeTs)
            ->setLastHistoryTs($lastHistoryTs)
            ->setRecipients($recipients)
            ->setSender($sender)
            ->setState($state)
            ->setStepId($stepId)
            ->setText($text)
            ->setType($type);
    }
    /**
     * Get action value
     * @return int|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param int $action
     * @return \StructType\WSTask
     */
    public function setAction($action = null)
    {
        // validation for constraint: int
        if (!is_null($action) && !(is_int($action) || ctype_digit($action))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get appointment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getAppointment()
    {
        return isset($this->appointment) ? $this->appointment : null;
    }
    /**
     * Set appointment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $appointment
     * @return \StructType\WSTask
     */
    public function setAppointment(\StructType\WSTimestamp $appointment = null)
    {
        if (is_null($appointment) || (is_array($appointment) && empty($appointment))) {
            unset($this->appointment);
        } else {
            $this->appointment = $appointment;
        }
        return $this;
    }
    /**
     * Get durationMinutes value
     * @return int|null
     */
    public function getDurationMinutes()
    {
        return $this->durationMinutes;
    }
    /**
     * Set durationMinutes value
     * @param int $durationMinutes
     * @return \StructType\WSTask
     */
    public function setDurationMinutes($durationMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($durationMinutes) && !(is_int($durationMinutes) || ctype_digit($durationMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationMinutes, true), gettype($durationMinutes)), __LINE__);
        }
        $this->durationMinutes = $durationMinutes;
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSExtension|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSExtension $extensions
     * @return \StructType\WSTask
     */
    public function setExtensions(\ArrayType\ArrayOfWSExtension $extensions = null)
    {
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Get flowId value
     * @return int|null
     */
    public function getFlowId()
    {
        return $this->flowId;
    }
    /**
     * Set flowId value
     * @param int $flowId
     * @return \StructType\WSTask
     */
    public function setFlowId($flowId = null)
    {
        // validation for constraint: int
        if (!is_null($flowId) && !(is_int($flowId) || ctype_digit($flowId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flowId, true), gettype($flowId)), __LINE__);
        }
        $this->flowId = $flowId;
        return $this;
    }
    /**
     * Get genericProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSGenericProperty|null
     */
    public function getGenericProperties()
    {
        return isset($this->genericProperties) ? $this->genericProperties : null;
    }
    /**
     * Set genericProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSGenericProperty $genericProperties
     * @return \StructType\WSTask
     */
    public function setGenericProperties(\ArrayType\ArrayOfWSGenericProperty $genericProperties = null)
    {
        if (is_null($genericProperties) || (is_array($genericProperties) && empty($genericProperties))) {
            unset($this->genericProperties);
        } else {
            $this->genericProperties = $genericProperties;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\WSTask
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get lastChangeTs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getLastChangeTs()
    {
        return isset($this->lastChangeTs) ? $this->lastChangeTs : null;
    }
    /**
     * Set lastChangeTs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $lastChangeTs
     * @return \StructType\WSTask
     */
    public function setLastChangeTs(\StructType\WSTimestamp $lastChangeTs = null)
    {
        if (is_null($lastChangeTs) || (is_array($lastChangeTs) && empty($lastChangeTs))) {
            unset($this->lastChangeTs);
        } else {
            $this->lastChangeTs = $lastChangeTs;
        }
        return $this;
    }
    /**
     * Get lastHistoryTs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getLastHistoryTs()
    {
        return isset($this->lastHistoryTs) ? $this->lastHistoryTs : null;
    }
    /**
     * Set lastHistoryTs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $lastHistoryTs
     * @return \StructType\WSTask
     */
    public function setLastHistoryTs(\StructType\WSTimestamp $lastHistoryTs = null)
    {
        if (is_null($lastHistoryTs) || (is_array($lastHistoryTs) && empty($lastHistoryTs))) {
            unset($this->lastHistoryTs);
        } else {
            $this->lastHistoryTs = $lastHistoryTs;
        }
        return $this;
    }
    /**
     * Get recipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSTaskRecipient|null
     */
    public function getRecipients()
    {
        return isset($this->recipients) ? $this->recipients : null;
    }
    /**
     * Set recipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSTaskRecipient $recipients
     * @return \StructType\WSTask
     */
    public function setRecipients(\ArrayType\ArrayOfWSTaskRecipient $recipients = null)
    {
        if (is_null($recipients) || (is_array($recipients) && empty($recipients))) {
            unset($this->recipients);
        } else {
            $this->recipients = $recipients;
        }
        return $this;
    }
    /**
     * Get sender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLink|null
     */
    public function getSender()
    {
        return isset($this->sender) ? $this->sender : null;
    }
    /**
     * Set sender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSLink $sender
     * @return \StructType\WSTask
     */
    public function setSender(\StructType\WSLink $sender = null)
    {
        if (is_null($sender) || (is_array($sender) && empty($sender))) {
            unset($this->sender);
        } else {
            $this->sender = $sender;
        }
        return $this;
    }
    /**
     * Get state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->state) ? $this->state : null;
    }
    /**
     * Set state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\WSTask
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->state);
        } else {
            $this->state = $state;
        }
        return $this;
    }
    /**
     * Get stepId value
     * @return int|null
     */
    public function getStepId()
    {
        return $this->stepId;
    }
    /**
     * Set stepId value
     * @param int $stepId
     * @return \StructType\WSTask
     */
    public function setStepId($stepId = null)
    {
        // validation for constraint: int
        if (!is_null($stepId) && !(is_int($stepId) || ctype_digit($stepId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stepId, true), gettype($stepId)), __LINE__);
        }
        $this->stepId = $stepId;
        return $this;
    }
    /**
     * Get text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->text) ? $this->text : null;
    }
    /**
     * Set text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \StructType\WSTask
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->text);
        } else {
            $this->text = $text;
        }
        return $this;
    }
    /**
     * Get type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->type) ? $this->type : null;
    }
    /**
     * Set type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \StructType\WSTask
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->type);
        } else {
            $this->type = $type;
        }
        return $this;
    }
}
