<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSCalendarEntry ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSCalendarEntry extends AbstractStructArrayBase
{
    /**
     * The WSCalendarEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSCalendarEntry[]
     */
    public $WSCalendarEntry;
    /**
     * Constructor method for ArrayOfWSCalendarEntry
     * @uses ArrayOfWSCalendarEntry::setWSCalendarEntry()
     * @param \StructType\WSCalendarEntry[] $wSCalendarEntry
     */
    public function __construct(array $wSCalendarEntry = array())
    {
        $this
            ->setWSCalendarEntry($wSCalendarEntry);
    }
    /**
     * Get WSCalendarEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSCalendarEntry[]|null
     */
    public function getWSCalendarEntry()
    {
        return isset($this->WSCalendarEntry) ? $this->WSCalendarEntry : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSCalendarEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSCalendarEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSCalendarEntryForArrayConstraintsFromSetWSCalendarEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSCalendarEntryWSCalendarEntryItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSCalendarEntryWSCalendarEntryItem instanceof \StructType\WSCalendarEntry) {
                $invalidValues[] = is_object($arrayOfWSCalendarEntryWSCalendarEntryItem) ? get_class($arrayOfWSCalendarEntryWSCalendarEntryItem) : sprintf('%s(%s)', gettype($arrayOfWSCalendarEntryWSCalendarEntryItem), var_export($arrayOfWSCalendarEntryWSCalendarEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSCalendarEntry property can only contain items of type \StructType\WSCalendarEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSCalendarEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSCalendarEntry[] $wSCalendarEntry
     * @return \ArrayType\ArrayOfWSCalendarEntry
     */
    public function setWSCalendarEntry(array $wSCalendarEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($wSCalendarEntryArrayErrorMessage = self::validateWSCalendarEntryForArrayConstraintsFromSetWSCalendarEntry($wSCalendarEntry))) {
            throw new \InvalidArgumentException($wSCalendarEntryArrayErrorMessage, __LINE__);
        }
        if (is_null($wSCalendarEntry) || (is_array($wSCalendarEntry) && empty($wSCalendarEntry))) {
            unset($this->WSCalendarEntry);
        } else {
            $this->WSCalendarEntry = $wSCalendarEntry;
        }
        return $this;
    }
    /**
     * Add item to WSCalendarEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\WSCalendarEntry $item
     * @return \ArrayType\ArrayOfWSCalendarEntry
     */
    public function addToWSCalendarEntry(\StructType\WSCalendarEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSCalendarEntry) {
            throw new \InvalidArgumentException(sprintf('The WSCalendarEntry property can only contain items of type \StructType\WSCalendarEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSCalendarEntry[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSCalendarEntry|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSCalendarEntry|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSCalendarEntry|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSCalendarEntry|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSCalendarEntry|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSCalendarEntry
     */
    public function getAttributeName()
    {
        return 'WSCalendarEntry';
    }
}
