<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createPersonE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePersonE $parameters
     * @return \StructType\CreatePersonEResponse|bool
     */
    public function createPersonE(\StructType\CreatePersonE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createPersonE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createLevelE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateLevelE $parameters
     * @return \StructType\CreateLevelEResponse|bool
     */
    public function createLevelE(\StructType\CreateLevelE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createLevelE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createEntryTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateEntryTerminal $parameters
     * @return \StructType\CreateEntryTerminalResponse|bool
     */
    public function createEntryTerminal(\StructType\CreateEntryTerminal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createEntryTerminal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateGroup $parameters
     * @return \StructType\CreateGroupResponse|bool
     */
    public function createGroup(\StructType\CreateGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createEntryDoor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateEntryDoor $parameters
     * @return \StructType\CreateEntryDoorResponse|bool
     */
    public function createEntryDoor(\StructType\CreateEntryDoor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createEntryDoor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomer $parameters
     * @return \StructType\CreateCustomerResponse|bool
     */
    public function createCustomer(\StructType\CreateCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createPerson
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePerson $parameters
     * @return \StructType\CreatePersonResponse|bool
     */
    public function createPerson(\StructType\CreatePerson $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createPerson($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createGroupMemberShip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateGroupMemberShip $parameters
     * @return \StructType\CreateGroupMemberShipResponse|bool
     */
    public function createGroupMemberShip(\StructType\CreateGroupMemberShip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createGroupMemberShip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createPersonsE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePersonsE $parameters
     * @return \StructType\CreatePersonsEResponse|bool
     */
    public function createPersonsE(\StructType\CreatePersonsE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createPersonsE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createTerminalsE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateTerminalsE $parameters
     * @return \StructType\CreateTerminalsEResponse|bool
     */
    public function createTerminalsE(\StructType\CreateTerminalsE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createTerminalsE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomers $parameters
     * @return \StructType\CreateCustomersResponse|bool
     */
    public function createCustomers(\StructType\CreateCustomers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createCustomers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createLevelsE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateLevelsE $parameters
     * @return \StructType\CreateLevelsEResponse|bool
     */
    public function createLevelsE(\StructType\CreateLevelsE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createLevelsE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createCustomerE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomerE $parameters
     * @return \StructType\CreateCustomerEResponse|bool
     */
    public function createCustomerE(\StructType\CreateCustomerE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createCustomerE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createTask
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateTask $parameters
     * @return \StructType\CreateTaskResponse|bool
     */
    public function createTask(\StructType\CreateTask $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createTask($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createCustomersE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomersE $parameters
     * @return \StructType\CreateCustomersEResponse|bool
     */
    public function createCustomersE(\StructType\CreateCustomersE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createCustomersE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createLevels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateLevels $parameters
     * @return \StructType\CreateLevelsResponse|bool
     */
    public function createLevels(\StructType\CreateLevels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createLevels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createBookingsE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateBookingsE $parameters
     * @return \StructType\CreateBookingsEResponse|bool
     */
    public function createBookingsE(\StructType\CreateBookingsE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createBookingsE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createLevel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateLevel $parameters
     * @return \StructType\CreateLevelResponse|bool
     */
    public function createLevel(\StructType\CreateLevel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->createLevel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateBookingsEResponse|\StructType\CreateCustomerEResponse|\StructType\CreateCustomerResponse|\StructType\CreateCustomersEResponse|\StructType\CreateCustomersResponse|\StructType\CreateEntryDoorResponse|\StructType\CreateEntryTerminalResponse|\StructType\CreateGroupMemberShipResponse|\StructType\CreateGroupResponse|\StructType\CreateLevelEResponse|\StructType\CreateLevelResponse|\StructType\CreateLevelsEResponse|\StructType\CreateLevelsResponse|\StructType\CreatePersonEResponse|\StructType\CreatePersonResponse|\StructType\CreatePersonsEResponse|\StructType\CreateTaskResponse|\StructType\CreateTerminalsEResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
