<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSWaypoint2 StructType
 * @subpackage Structs
 */
class WSWaypoint2 extends AbstractStructBase
{
    /**
     * The TS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TS;
    /**
     * The dir
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $dir;
    /**
     * The lat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lat;
    /**
     * The lon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lon;
    /**
     * The speed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $speed;
    /**
     * Constructor method for WSWaypoint2
     * @uses WSWaypoint2::setTS()
     * @uses WSWaypoint2::setDir()
     * @uses WSWaypoint2::setLat()
     * @uses WSWaypoint2::setLon()
     * @uses WSWaypoint2::setSpeed()
     * @param int $tS
     * @param int $dir
     * @param int $lat
     * @param int $lon
     * @param int $speed
     */
    public function __construct($tS = null, $dir = null, $lat = null, $lon = null, $speed = null)
    {
        $this
            ->setTS($tS)
            ->setDir($dir)
            ->setLat($lat)
            ->setLon($lon)
            ->setSpeed($speed);
    }
    /**
     * Get TS value
     * @return int|null
     */
    public function getTS()
    {
        return $this->TS;
    }
    /**
     * Set TS value
     * @param int $tS
     * @return \StructType\WSWaypoint2
     */
    public function setTS($tS = null)
    {
        // validation for constraint: int
        if (!is_null($tS) && !(is_int($tS) || ctype_digit($tS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tS, true), gettype($tS)), __LINE__);
        }
        $this->TS = $tS;
        return $this;
    }
    /**
     * Get dir value
     * @return int|null
     */
    public function getDir()
    {
        return $this->dir;
    }
    /**
     * Set dir value
     * @param int $dir
     * @return \StructType\WSWaypoint2
     */
    public function setDir($dir = null)
    {
        // validation for constraint: int
        if (!is_null($dir) && !(is_int($dir) || ctype_digit($dir))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dir, true), gettype($dir)), __LINE__);
        }
        $this->dir = $dir;
        return $this;
    }
    /**
     * Get lat value
     * @return int|null
     */
    public function getLat()
    {
        return $this->lat;
    }
    /**
     * Set lat value
     * @param int $lat
     * @return \StructType\WSWaypoint2
     */
    public function setLat($lat = null)
    {
        // validation for constraint: int
        if (!is_null($lat) && !(is_int($lat) || ctype_digit($lat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lat, true), gettype($lat)), __LINE__);
        }
        $this->lat = $lat;
        return $this;
    }
    /**
     * Get lon value
     * @return int|null
     */
    public function getLon()
    {
        return $this->lon;
    }
    /**
     * Set lon value
     * @param int $lon
     * @return \StructType\WSWaypoint2
     */
    public function setLon($lon = null)
    {
        // validation for constraint: int
        if (!is_null($lon) && !(is_int($lon) || ctype_digit($lon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lon, true), gettype($lon)), __LINE__);
        }
        $this->lon = $lon;
        return $this;
    }
    /**
     * Get speed value
     * @return int|null
     */
    public function getSpeed()
    {
        return $this->speed;
    }
    /**
     * Set speed value
     * @param int $speed
     * @return \StructType\WSWaypoint2
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !(is_int($speed) || ctype_digit($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->speed = $speed;
        return $this;
    }
}
