<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTimestamp StructType
 * @subpackage Structs
 */
class WSTimestamp extends AbstractStructBase
{
    /**
     * The TS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TS;
    /**
     * The day
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $day;
    /**
     * The hour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $hour;
    /**
     * The min
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $min;
    /**
     * The month
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $month;
    /**
     * The sec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sec;
    /**
     * The timeInSeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $timeInSeconds;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $timestamp;
    /**
     * The year
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $year;
    /**
     * Constructor method for WSTimestamp
     * @uses WSTimestamp::setTS()
     * @uses WSTimestamp::setDay()
     * @uses WSTimestamp::setHour()
     * @uses WSTimestamp::setMin()
     * @uses WSTimestamp::setMonth()
     * @uses WSTimestamp::setSec()
     * @uses WSTimestamp::setTimeInSeconds()
     * @uses WSTimestamp::setTimestamp()
     * @uses WSTimestamp::setYear()
     * @param int $tS
     * @param int $day
     * @param int $hour
     * @param int $min
     * @param int $month
     * @param int $sec
     * @param int $timeInSeconds
     * @param string $timestamp
     * @param int $year
     */
    public function __construct($tS = null, $day = null, $hour = null, $min = null, $month = null, $sec = null, $timeInSeconds = null, $timestamp = null, $year = null)
    {
        $this
            ->setTS($tS)
            ->setDay($day)
            ->setHour($hour)
            ->setMin($min)
            ->setMonth($month)
            ->setSec($sec)
            ->setTimeInSeconds($timeInSeconds)
            ->setTimestamp($timestamp)
            ->setYear($year);
    }
    /**
     * Get TS value
     * @return int|null
     */
    public function getTS()
    {
        return $this->TS;
    }
    /**
     * Set TS value
     * @param int $tS
     * @return \StructType\WSTimestamp
     */
    public function setTS($tS = null)
    {
        // validation for constraint: int
        if (!is_null($tS) && !(is_int($tS) || ctype_digit($tS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tS, true), gettype($tS)), __LINE__);
        }
        $this->TS = $tS;
        return $this;
    }
    /**
     * Get day value
     * @return int|null
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param int $day
     * @return \StructType\WSTimestamp
     */
    public function setDay($day = null)
    {
        // validation for constraint: int
        if (!is_null($day) && !(is_int($day) || ctype_digit($day))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($day, true), gettype($day)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get hour value
     * @return int|null
     */
    public function getHour()
    {
        return $this->hour;
    }
    /**
     * Set hour value
     * @param int $hour
     * @return \StructType\WSTimestamp
     */
    public function setHour($hour = null)
    {
        // validation for constraint: int
        if (!is_null($hour) && !(is_int($hour) || ctype_digit($hour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hour, true), gettype($hour)), __LINE__);
        }
        $this->hour = $hour;
        return $this;
    }
    /**
     * Get min value
     * @return int|null
     */
    public function getMin()
    {
        return $this->min;
    }
    /**
     * Set min value
     * @param int $min
     * @return \StructType\WSTimestamp
     */
    public function setMin($min = null)
    {
        // validation for constraint: int
        if (!is_null($min) && !(is_int($min) || ctype_digit($min))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($min, true), gettype($min)), __LINE__);
        }
        $this->min = $min;
        return $this;
    }
    /**
     * Get month value
     * @return int|null
     */
    public function getMonth()
    {
        return $this->month;
    }
    /**
     * Set month value
     * @param int $month
     * @return \StructType\WSTimestamp
     */
    public function setMonth($month = null)
    {
        // validation for constraint: int
        if (!is_null($month) && !(is_int($month) || ctype_digit($month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($month, true), gettype($month)), __LINE__);
        }
        $this->month = $month;
        return $this;
    }
    /**
     * Get sec value
     * @return int|null
     */
    public function getSec()
    {
        return $this->sec;
    }
    /**
     * Set sec value
     * @param int $sec
     * @return \StructType\WSTimestamp
     */
    public function setSec($sec = null)
    {
        // validation for constraint: int
        if (!is_null($sec) && !(is_int($sec) || ctype_digit($sec))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sec, true), gettype($sec)), __LINE__);
        }
        $this->sec = $sec;
        return $this;
    }
    /**
     * Get timeInSeconds value
     * @return int|null
     */
    public function getTimeInSeconds()
    {
        return $this->timeInSeconds;
    }
    /**
     * Set timeInSeconds value
     * @param int $timeInSeconds
     * @return \StructType\WSTimestamp
     */
    public function setTimeInSeconds($timeInSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($timeInSeconds) && !(is_int($timeInSeconds) || ctype_digit($timeInSeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeInSeconds, true), gettype($timeInSeconds)), __LINE__);
        }
        $this->timeInSeconds = $timeInSeconds;
        return $this;
    }
    /**
     * Get timestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimestamp()
    {
        return isset($this->timestamp) ? $this->timestamp : null;
    }
    /**
     * Set timestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timestamp
     * @return \StructType\WSTimestamp
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        if (is_null($timestamp) || (is_array($timestamp) && empty($timestamp))) {
            unset($this->timestamp);
        } else {
            $this->timestamp = $timestamp;
        }
        return $this;
    }
    /**
     * Get year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param int $year
     * @return \StructType\WSTimestamp
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
}
