<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTerminal StructType
 * @subpackage Structs
 */
class WSTerminal extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The lastCommunicationTS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $lastCommunicationTS;
    /**
     * The lastConfigurationTS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $lastConfigurationTS;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The nr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $nr;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $type;
    /**
     * Constructor method for WSTerminal
     * @uses WSTerminal::setId()
     * @uses WSTerminal::setLastCommunicationTS()
     * @uses WSTerminal::setLastConfigurationTS()
     * @uses WSTerminal::setName()
     * @uses WSTerminal::setNr()
     * @uses WSTerminal::setType()
     * @param int $id
     * @param \StructType\WSTimestamp $lastCommunicationTS
     * @param \StructType\WSTimestamp $lastConfigurationTS
     * @param string $name
     * @param int $nr
     * @param int $type
     */
    public function __construct($id = null, \StructType\WSTimestamp $lastCommunicationTS = null, \StructType\WSTimestamp $lastConfigurationTS = null, $name = null, $nr = null, $type = null)
    {
        $this
            ->setId($id)
            ->setLastCommunicationTS($lastCommunicationTS)
            ->setLastConfigurationTS($lastConfigurationTS)
            ->setName($name)
            ->setNr($nr)
            ->setType($type);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\WSTerminal
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get lastCommunicationTS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getLastCommunicationTS()
    {
        return isset($this->lastCommunicationTS) ? $this->lastCommunicationTS : null;
    }
    /**
     * Set lastCommunicationTS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $lastCommunicationTS
     * @return \StructType\WSTerminal
     */
    public function setLastCommunicationTS(\StructType\WSTimestamp $lastCommunicationTS = null)
    {
        if (is_null($lastCommunicationTS) || (is_array($lastCommunicationTS) && empty($lastCommunicationTS))) {
            unset($this->lastCommunicationTS);
        } else {
            $this->lastCommunicationTS = $lastCommunicationTS;
        }
        return $this;
    }
    /**
     * Get lastConfigurationTS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getLastConfigurationTS()
    {
        return isset($this->lastConfigurationTS) ? $this->lastConfigurationTS : null;
    }
    /**
     * Set lastConfigurationTS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $lastConfigurationTS
     * @return \StructType\WSTerminal
     */
    public function setLastConfigurationTS(\StructType\WSTimestamp $lastConfigurationTS = null)
    {
        if (is_null($lastConfigurationTS) || (is_array($lastConfigurationTS) && empty($lastConfigurationTS))) {
            unset($this->lastConfigurationTS);
        } else {
            $this->lastConfigurationTS = $lastConfigurationTS;
        }
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\WSTerminal
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get nr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNr()
    {
        return isset($this->nr) ? $this->nr : null;
    }
    /**
     * Set nr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nr
     * @return \StructType\WSTerminal
     */
    public function setNr($nr = null)
    {
        // validation for constraint: int
        if (!is_null($nr) && !(is_int($nr) || ctype_digit($nr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nr, true), gettype($nr)), __LINE__);
        }
        if (is_null($nr) || (is_array($nr) && empty($nr))) {
            unset($this->nr);
        } else {
            $this->nr = $nr;
        }
        return $this;
    }
    /**
     * Get type value
     * @return int|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \StructType\WSTerminal
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
