<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSPropertyDefinition StructType
 * @subpackage Structs
 */
class WSPropertyDefinition extends AbstractStructBase
{
    /**
     * The additionalValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $additionalValue;
    /**
     * The extraValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $extraValues;
    /**
     * The heightHint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $heightHint;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The linkInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $linkInfos;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The propKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $propKey;
    /**
     * The relation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $relation;
    /**
     * The scriptVariable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $scriptVariable;
    /**
     * The storeMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $storeMode;
    /**
     * The validLinkTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $validLinkTypes;
    /**
     * The valueHint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $valueHint;
    /**
     * The valueLinkType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $valueLinkType;
    /**
     * The valueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $valueType;
    /**
     * Constructor method for WSPropertyDefinition
     * @uses WSPropertyDefinition::setAdditionalValue()
     * @uses WSPropertyDefinition::setExtraValues()
     * @uses WSPropertyDefinition::setHeightHint()
     * @uses WSPropertyDefinition::setId()
     * @uses WSPropertyDefinition::setLinkInfos()
     * @uses WSPropertyDefinition::setName()
     * @uses WSPropertyDefinition::setPropKey()
     * @uses WSPropertyDefinition::setRelation()
     * @uses WSPropertyDefinition::setScriptVariable()
     * @uses WSPropertyDefinition::setStoreMode()
     * @uses WSPropertyDefinition::setValidLinkTypes()
     * @uses WSPropertyDefinition::setValueHint()
     * @uses WSPropertyDefinition::setValueLinkType()
     * @uses WSPropertyDefinition::setValueType()
     * @param int $additionalValue
     * @param \ArrayType\ArrayOfWSKeyValue $extraValues
     * @param int $heightHint
     * @param int $id
     * @param \ArrayType\ArrayOfInt $linkInfos
     * @param string $name
     * @param int $propKey
     * @param bool $relation
     * @param string $scriptVariable
     * @param int $storeMode
     * @param \ArrayType\ArrayOfInt $validLinkTypes
     * @param int $valueHint
     * @param int $valueLinkType
     * @param int $valueType
     */
    public function __construct($additionalValue = null, \ArrayType\ArrayOfWSKeyValue $extraValues = null, $heightHint = null, $id = null, \ArrayType\ArrayOfInt $linkInfos = null, $name = null, $propKey = null, $relation = null, $scriptVariable = null, $storeMode = null, \ArrayType\ArrayOfInt $validLinkTypes = null, $valueHint = null, $valueLinkType = null, $valueType = null)
    {
        $this
            ->setAdditionalValue($additionalValue)
            ->setExtraValues($extraValues)
            ->setHeightHint($heightHint)
            ->setId($id)
            ->setLinkInfos($linkInfos)
            ->setName($name)
            ->setPropKey($propKey)
            ->setRelation($relation)
            ->setScriptVariable($scriptVariable)
            ->setStoreMode($storeMode)
            ->setValidLinkTypes($validLinkTypes)
            ->setValueHint($valueHint)
            ->setValueLinkType($valueLinkType)
            ->setValueType($valueType);
    }
    /**
     * Get additionalValue value
     * @return int|null
     */
    public function getAdditionalValue()
    {
        return $this->additionalValue;
    }
    /**
     * Set additionalValue value
     * @param int $additionalValue
     * @return \StructType\WSPropertyDefinition
     */
    public function setAdditionalValue($additionalValue = null)
    {
        // validation for constraint: int
        if (!is_null($additionalValue) && !(is_int($additionalValue) || ctype_digit($additionalValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($additionalValue, true), gettype($additionalValue)), __LINE__);
        }
        $this->additionalValue = $additionalValue;
        return $this;
    }
    /**
     * Get extraValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getExtraValues()
    {
        return isset($this->extraValues) ? $this->extraValues : null;
    }
    /**
     * Set extraValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $extraValues
     * @return \StructType\WSPropertyDefinition
     */
    public function setExtraValues(\ArrayType\ArrayOfWSKeyValue $extraValues = null)
    {
        if (is_null($extraValues) || (is_array($extraValues) && empty($extraValues))) {
            unset($this->extraValues);
        } else {
            $this->extraValues = $extraValues;
        }
        return $this;
    }
    /**
     * Get heightHint value
     * @return int|null
     */
    public function getHeightHint()
    {
        return $this->heightHint;
    }
    /**
     * Set heightHint value
     * @param int $heightHint
     * @return \StructType\WSPropertyDefinition
     */
    public function setHeightHint($heightHint = null)
    {
        // validation for constraint: int
        if (!is_null($heightHint) && !(is_int($heightHint) || ctype_digit($heightHint))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heightHint, true), gettype($heightHint)), __LINE__);
        }
        $this->heightHint = $heightHint;
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\WSPropertyDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get linkInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getLinkInfos()
    {
        return isset($this->linkInfos) ? $this->linkInfos : null;
    }
    /**
     * Set linkInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInt $linkInfos
     * @return \StructType\WSPropertyDefinition
     */
    public function setLinkInfos(\ArrayType\ArrayOfInt $linkInfos = null)
    {
        if (is_null($linkInfos) || (is_array($linkInfos) && empty($linkInfos))) {
            unset($this->linkInfos);
        } else {
            $this->linkInfos = $linkInfos;
        }
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\WSPropertyDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get propKey value
     * @return int|null
     */
    public function getPropKey()
    {
        return $this->propKey;
    }
    /**
     * Set propKey value
     * @param int $propKey
     * @return \StructType\WSPropertyDefinition
     */
    public function setPropKey($propKey = null)
    {
        // validation for constraint: int
        if (!is_null($propKey) && !(is_int($propKey) || ctype_digit($propKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($propKey, true), gettype($propKey)), __LINE__);
        }
        $this->propKey = $propKey;
        return $this;
    }
    /**
     * Get relation value
     * @return bool|null
     */
    public function getRelation()
    {
        return $this->relation;
    }
    /**
     * Set relation value
     * @param bool $relation
     * @return \StructType\WSPropertyDefinition
     */
    public function setRelation($relation = null)
    {
        // validation for constraint: boolean
        if (!is_null($relation) && !is_bool($relation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($relation, true), gettype($relation)), __LINE__);
        }
        $this->relation = $relation;
        return $this;
    }
    /**
     * Get scriptVariable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScriptVariable()
    {
        return isset($this->scriptVariable) ? $this->scriptVariable : null;
    }
    /**
     * Set scriptVariable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scriptVariable
     * @return \StructType\WSPropertyDefinition
     */
    public function setScriptVariable($scriptVariable = null)
    {
        // validation for constraint: string
        if (!is_null($scriptVariable) && !is_string($scriptVariable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptVariable, true), gettype($scriptVariable)), __LINE__);
        }
        if (is_null($scriptVariable) || (is_array($scriptVariable) && empty($scriptVariable))) {
            unset($this->scriptVariable);
        } else {
            $this->scriptVariable = $scriptVariable;
        }
        return $this;
    }
    /**
     * Get storeMode value
     * @return int|null
     */
    public function getStoreMode()
    {
        return $this->storeMode;
    }
    /**
     * Set storeMode value
     * @param int $storeMode
     * @return \StructType\WSPropertyDefinition
     */
    public function setStoreMode($storeMode = null)
    {
        // validation for constraint: int
        if (!is_null($storeMode) && !(is_int($storeMode) || ctype_digit($storeMode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeMode, true), gettype($storeMode)), __LINE__);
        }
        $this->storeMode = $storeMode;
        return $this;
    }
    /**
     * Get validLinkTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getValidLinkTypes()
    {
        return isset($this->validLinkTypes) ? $this->validLinkTypes : null;
    }
    /**
     * Set validLinkTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInt $validLinkTypes
     * @return \StructType\WSPropertyDefinition
     */
    public function setValidLinkTypes(\ArrayType\ArrayOfInt $validLinkTypes = null)
    {
        if (is_null($validLinkTypes) || (is_array($validLinkTypes) && empty($validLinkTypes))) {
            unset($this->validLinkTypes);
        } else {
            $this->validLinkTypes = $validLinkTypes;
        }
        return $this;
    }
    /**
     * Get valueHint value
     * @return int|null
     */
    public function getValueHint()
    {
        return $this->valueHint;
    }
    /**
     * Set valueHint value
     * @param int $valueHint
     * @return \StructType\WSPropertyDefinition
     */
    public function setValueHint($valueHint = null)
    {
        // validation for constraint: int
        if (!is_null($valueHint) && !(is_int($valueHint) || ctype_digit($valueHint))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valueHint, true), gettype($valueHint)), __LINE__);
        }
        $this->valueHint = $valueHint;
        return $this;
    }
    /**
     * Get valueLinkType value
     * @return int|null
     */
    public function getValueLinkType()
    {
        return $this->valueLinkType;
    }
    /**
     * Set valueLinkType value
     * @param int $valueLinkType
     * @return \StructType\WSPropertyDefinition
     */
    public function setValueLinkType($valueLinkType = null)
    {
        // validation for constraint: int
        if (!is_null($valueLinkType) && !(is_int($valueLinkType) || ctype_digit($valueLinkType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valueLinkType, true), gettype($valueLinkType)), __LINE__);
        }
        $this->valueLinkType = $valueLinkType;
        return $this;
    }
    /**
     * Get valueType value
     * @return int|null
     */
    public function getValueType()
    {
        return $this->valueType;
    }
    /**
     * Set valueType value
     * @param int $valueType
     * @return \StructType\WSPropertyDefinition
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: int
        if (!is_null($valueType) && !(is_int($valueType) || ctype_digit($valueType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valueType, true), gettype($valueType)), __LINE__);
        }
        $this->valueType = $valueType;
        return $this;
    }
}
