<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSChange StructType
 * @subpackage Structs
 */
class WSChange extends AbstractStructBase
{
    /**
     * The action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $action;
    /**
     * The change
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $change;
    /**
     * The dataOwnerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $dataOwnerId;
    /**
     * The dataTs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $dataTs;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The linkId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $linkId;
    /**
     * The linkType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $linkType;
    /**
     * The personID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $personID;
    /**
     * The ts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $ts;
    /**
     * Constructor method for WSChange
     * @uses WSChange::setAction()
     * @uses WSChange::setChange()
     * @uses WSChange::setDataOwnerId()
     * @uses WSChange::setDataTs()
     * @uses WSChange::setId()
     * @uses WSChange::setLinkId()
     * @uses WSChange::setLinkType()
     * @uses WSChange::setPersonID()
     * @uses WSChange::setTs()
     * @param int $action
     * @param string $change
     * @param int $dataOwnerId
     * @param \StructType\WSTimestamp $dataTs
     * @param int $id
     * @param int $linkId
     * @param int $linkType
     * @param int $personID
     * @param \StructType\WSTimestamp $ts
     */
    public function __construct($action = null, $change = null, $dataOwnerId = null, \StructType\WSTimestamp $dataTs = null, $id = null, $linkId = null, $linkType = null, $personID = null, \StructType\WSTimestamp $ts = null)
    {
        $this
            ->setAction($action)
            ->setChange($change)
            ->setDataOwnerId($dataOwnerId)
            ->setDataTs($dataTs)
            ->setId($id)
            ->setLinkId($linkId)
            ->setLinkType($linkType)
            ->setPersonID($personID)
            ->setTs($ts);
    }
    /**
     * Get action value
     * @return int|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param int $action
     * @return \StructType\WSChange
     */
    public function setAction($action = null)
    {
        // validation for constraint: int
        if (!is_null($action) && !(is_int($action) || ctype_digit($action))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get change value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChange()
    {
        return isset($this->change) ? $this->change : null;
    }
    /**
     * Set change value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $change
     * @return \StructType\WSChange
     */
    public function setChange($change = null)
    {
        // validation for constraint: string
        if (!is_null($change) && !is_string($change)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($change, true), gettype($change)), __LINE__);
        }
        if (is_null($change) || (is_array($change) && empty($change))) {
            unset($this->change);
        } else {
            $this->change = $change;
        }
        return $this;
    }
    /**
     * Get dataOwnerId value
     * @return int|null
     */
    public function getDataOwnerId()
    {
        return $this->dataOwnerId;
    }
    /**
     * Set dataOwnerId value
     * @param int $dataOwnerId
     * @return \StructType\WSChange
     */
    public function setDataOwnerId($dataOwnerId = null)
    {
        // validation for constraint: int
        if (!is_null($dataOwnerId) && !(is_int($dataOwnerId) || ctype_digit($dataOwnerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dataOwnerId, true), gettype($dataOwnerId)), __LINE__);
        }
        $this->dataOwnerId = $dataOwnerId;
        return $this;
    }
    /**
     * Get dataTs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getDataTs()
    {
        return isset($this->dataTs) ? $this->dataTs : null;
    }
    /**
     * Set dataTs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $dataTs
     * @return \StructType\WSChange
     */
    public function setDataTs(\StructType\WSTimestamp $dataTs = null)
    {
        if (is_null($dataTs) || (is_array($dataTs) && empty($dataTs))) {
            unset($this->dataTs);
        } else {
            $this->dataTs = $dataTs;
        }
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\WSChange
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get linkId value
     * @return int|null
     */
    public function getLinkId()
    {
        return $this->linkId;
    }
    /**
     * Set linkId value
     * @param int $linkId
     * @return \StructType\WSChange
     */
    public function setLinkId($linkId = null)
    {
        // validation for constraint: int
        if (!is_null($linkId) && !(is_int($linkId) || ctype_digit($linkId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkId, true), gettype($linkId)), __LINE__);
        }
        $this->linkId = $linkId;
        return $this;
    }
    /**
     * Get linkType value
     * @return int|null
     */
    public function getLinkType()
    {
        return $this->linkType;
    }
    /**
     * Set linkType value
     * @param int $linkType
     * @return \StructType\WSChange
     */
    public function setLinkType($linkType = null)
    {
        // validation for constraint: int
        if (!is_null($linkType) && !(is_int($linkType) || ctype_digit($linkType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkType, true), gettype($linkType)), __LINE__);
        }
        $this->linkType = $linkType;
        return $this;
    }
    /**
     * Get personID value
     * @return int|null
     */
    public function getPersonID()
    {
        return $this->personID;
    }
    /**
     * Set personID value
     * @param int $personID
     * @return \StructType\WSChange
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: int
        if (!is_null($personID) && !(is_int($personID) || ctype_digit($personID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personID, true), gettype($personID)), __LINE__);
        }
        $this->personID = $personID;
        return $this;
    }
    /**
     * Get ts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getTs()
    {
        return isset($this->ts) ? $this->ts : null;
    }
    /**
     * Set ts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $ts
     * @return \StructType\WSChange
     */
    public function setTs(\StructType\WSTimestamp $ts = null)
    {
        if (is_null($ts) || (is_array($ts) && empty($ts))) {
            unset($this->ts);
        } else {
            $this->ts = $ts;
        }
        return $this;
    }
}
