<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Quick ServiceType
 * @subpackage Services
 */
class Quick extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named quickMoveGroupMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QuickMoveGroupMember $parameters
     * @return \StructType\QuickMoveGroupMemberResponse|bool
     */
    public function quickMoveGroupMember(\StructType\QuickMoveGroupMember $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->quickMoveGroupMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named quickAddGroupMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QuickAddGroupMember $parameters
     * @return \StructType\QuickAddGroupMemberResponse|bool
     */
    public function quickAddGroupMember(\StructType\QuickAddGroupMember $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->quickAddGroupMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named quickDeleteGroupMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QuickDeleteGroupMember $parameters
     * @return \StructType\QuickDeleteGroupMemberResponse|bool
     */
    public function quickDeleteGroupMember(\StructType\QuickDeleteGroupMember $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->quickDeleteGroupMember($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\QuickAddGroupMemberResponse|\StructType\QuickDeleteGroupMemberResponse|\StructType\QuickMoveGroupMemberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
