<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTerminalBooking StructType
 * @subpackage Structs
 */
class WSTerminalBooking extends AbstractStructBase
{
    /**
     * The bookingData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bookingData;
    /**
     * The terminalid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $terminalid;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $timestamp;
    /**
     * Constructor method for WSTerminalBooking
     * @uses WSTerminalBooking::setBookingData()
     * @uses WSTerminalBooking::setTerminalid()
     * @uses WSTerminalBooking::setTimestamp()
     * @param string $bookingData
     * @param int $terminalid
     * @param int $timestamp
     */
    public function __construct($bookingData = null, $terminalid = null, $timestamp = null)
    {
        $this
            ->setBookingData($bookingData)
            ->setTerminalid($terminalid)
            ->setTimestamp($timestamp);
    }
    /**
     * Get bookingData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingData()
    {
        return isset($this->bookingData) ? $this->bookingData : null;
    }
    /**
     * Set bookingData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingData
     * @return \StructType\WSTerminalBooking
     */
    public function setBookingData($bookingData = null)
    {
        // validation for constraint: string
        if (!is_null($bookingData) && !is_string($bookingData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingData, true), gettype($bookingData)), __LINE__);
        }
        if (is_null($bookingData) || (is_array($bookingData) && empty($bookingData))) {
            unset($this->bookingData);
        } else {
            $this->bookingData = $bookingData;
        }
        return $this;
    }
    /**
     * Get terminalid value
     * @return int|null
     */
    public function getTerminalid()
    {
        return $this->terminalid;
    }
    /**
     * Set terminalid value
     * @param int $terminalid
     * @return \StructType\WSTerminalBooking
     */
    public function setTerminalid($terminalid = null)
    {
        // validation for constraint: int
        if (!is_null($terminalid) && !(is_int($terminalid) || ctype_digit($terminalid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalid, true), gettype($terminalid)), __LINE__);
        }
        $this->terminalid = $terminalid;
        return $this;
    }
    /**
     * Get timestamp value
     * @return int|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param int $timestamp
     * @return \StructType\WSTerminalBooking
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: int
        if (!is_null($timestamp) && !(is_int($timestamp) || ctype_digit($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
}
