<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParaPuanGuncelleRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ParaPuanGuncelleRequest
 * @subpackage Structs
 */
class ParaPuanGuncelleRequest extends AbstractStructBase
{
    /**
     * The IslemTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IslemTipi;
    /**
     * The ParaPuan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParaPuan;
    /**
     * The UyeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeID;
    /**
     * Constructor method for ParaPuanGuncelleRequest
     * @uses ParaPuanGuncelleRequest::setIslemTipi()
     * @uses ParaPuanGuncelleRequest::setParaPuan()
     * @uses ParaPuanGuncelleRequest::setUyeID()
     * @param string $islemTipi
     * @param int $paraPuan
     * @param int $uyeID
     */
    public function __construct($islemTipi = null, $paraPuan = null, $uyeID = null)
    {
        $this
            ->setIslemTipi($islemTipi)
            ->setParaPuan($paraPuan)
            ->setUyeID($uyeID);
    }
    /**
     * Get IslemTipi value
     * @return string|null
     */
    public function getIslemTipi()
    {
        return $this->IslemTipi;
    }
    /**
     * Set IslemTipi value
     * @uses \EnumType\ParaPuanGuncelleIslemTipi::valueIsValid()
     * @uses \EnumType\ParaPuanGuncelleIslemTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $islemTipi
     * @return \StructType\ParaPuanGuncelleRequest
     */
    public function setIslemTipi($islemTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ParaPuanGuncelleIslemTipi::valueIsValid($islemTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ParaPuanGuncelleIslemTipi', is_array($islemTipi) ? implode(', ', $islemTipi) : var_export($islemTipi, true), implode(', ', \EnumType\ParaPuanGuncelleIslemTipi::getValidValues())), __LINE__);
        }
        $this->IslemTipi = $islemTipi;
        return $this;
    }
    /**
     * Get ParaPuan value
     * @return int|null
     */
    public function getParaPuan()
    {
        return $this->ParaPuan;
    }
    /**
     * Set ParaPuan value
     * @param int $paraPuan
     * @return \StructType\ParaPuanGuncelleRequest
     */
    public function setParaPuan($paraPuan = null)
    {
        // validation for constraint: int
        if (!is_null($paraPuan) && !(is_int($paraPuan) || ctype_digit($paraPuan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paraPuan, true), gettype($paraPuan)), __LINE__);
        }
        $this->ParaPuan = $paraPuan;
        return $this;
    }
    /**
     * Get UyeID value
     * @return int|null
     */
    public function getUyeID()
    {
        return $this->UyeID;
    }
    /**
     * Set UyeID value
     * @param int $uyeID
     * @return \StructType\ParaPuanGuncelleRequest
     */
    public function setUyeID($uyeID = null)
    {
        // validation for constraint: int
        if (!is_null($uyeID) && !(is_int($uyeID) || ctype_digit($uyeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeID, true), gettype($uyeID)), __LINE__);
        }
        $this->UyeID = $uyeID;
        return $this;
    }
}
