<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Select ServiceType
 * @subpackage Services
 */
class Select extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SelectUyeler
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUyeler $parameters
     * @return \StructType\SelectUyelerResponse|bool
     */
    public function SelectUyeler(\StructType\SelectUyeler $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUyeler($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUyeIdByMailOrTel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUyeIdByMailOrTel $parameters
     * @return \StructType\SelectUyeIdByMailOrTelResponse|bool
     */
    public function SelectUyeIdByMailOrTel(\StructType\SelectUyeIdByMailOrTel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUyeIdByMailOrTel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUyeAdres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUyeAdres $parameters
     * @return \StructType\SelectUyeAdresResponse|bool
     */
    public function SelectUyeAdres(\StructType\SelectUyeAdres $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUyeAdres($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUyeTuru
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUyeTuru $parameters
     * @return \StructType\SelectUyeTuruResponse|bool
     */
    public function SelectUyeTuru(\StructType\SelectUyeTuru $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUyeTuru($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUyeIzinGecmisi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUyeIzinGecmisi $parameters
     * @return \StructType\SelectUyeIzinGecmisiResponse|bool
     */
    public function SelectUyeIzinGecmisi(\StructType\SelectUyeIzinGecmisi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUyeIzinGecmisi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SelectUyeAdresResponse|\StructType\SelectUyeIdByMailOrTelResponse|\StructType\SelectUyeIzinGecmisiResponse|\StructType\SelectUyelerResponse|\StructType\SelectUyeTuruResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
