<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tracking StructType
 * @subpackage Structs
 */
class Tracking extends AbstractStructBase
{
    /**
     * The CodeGroupe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeGroupe;
    /**
     * The CodeCentre
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeCentre;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * Constructor method for Tracking
     * @uses Tracking::setCodeGroupe()
     * @uses Tracking::setCodeCentre()
     * @uses Tracking::setAction()
     * @uses Tracking::setUrl()
     * @param string $codeGroupe
     * @param string $codeCentre
     * @param string $action
     * @param string $url
     */
    public function __construct($codeGroupe = null, $codeCentre = null, $action = null, $url = null)
    {
        $this
            ->setCodeGroupe($codeGroupe)
            ->setCodeCentre($codeCentre)
            ->setAction($action)
            ->setUrl($url);
    }
    /**
     * Get CodeGroupe value
     * @return string|null
     */
    public function getCodeGroupe()
    {
        return $this->CodeGroupe;
    }
    /**
     * Set CodeGroupe value
     * @param string $codeGroupe
     * @return \StructType\Tracking
     */
    public function setCodeGroupe($codeGroupe = null)
    {
        // validation for constraint: string
        if (!is_null($codeGroupe) && !is_string($codeGroupe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeGroupe)), __LINE__);
        }
        $this->CodeGroupe = $codeGroupe;
        return $this;
    }
    /**
     * Get CodeCentre value
     * @return string|null
     */
    public function getCodeCentre()
    {
        return $this->CodeCentre;
    }
    /**
     * Set CodeCentre value
     * @param string $codeCentre
     * @return \StructType\Tracking
     */
    public function setCodeCentre($codeCentre = null)
    {
        // validation for constraint: string
        if (!is_null($codeCentre) && !is_string($codeCentre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeCentre)), __LINE__);
        }
        $this->CodeCentre = $codeCentre;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param string $action
     * @return \StructType\Tracking
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($action)), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\Tracking
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tracking
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
