<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReponseTarif StructType
 * @subpackage Structs
 */
class ReponseTarif extends AbstractStructBase
{
    /**
     * The Resultat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resultat;
    /**
     * The CodeErreur
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeErreur;
    /**
     * The LibelleErreur
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibelleErreur;
    /**
     * The ListeTarif
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTarif
     */
    public $ListeTarif;
    /**
     * Constructor method for ReponseTarif
     * @uses ReponseTarif::setResultat()
     * @uses ReponseTarif::setCodeErreur()
     * @uses ReponseTarif::setLibelleErreur()
     * @uses ReponseTarif::setListeTarif()
     * @param string $resultat
     * @param string $codeErreur
     * @param string $libelleErreur
     * @param \ArrayType\ArrayOfTarif $listeTarif
     */
    public function __construct($resultat = null, $codeErreur = null, $libelleErreur = null, \ArrayType\ArrayOfTarif $listeTarif = null)
    {
        $this
            ->setResultat($resultat)
            ->setCodeErreur($codeErreur)
            ->setLibelleErreur($libelleErreur)
            ->setListeTarif($listeTarif);
    }
    /**
     * Get Resultat value
     * @return string|null
     */
    public function getResultat()
    {
        return $this->Resultat;
    }
    /**
     * Set Resultat value
     * @param string $resultat
     * @return \StructType\ReponseTarif
     */
    public function setResultat($resultat = null)
    {
        // validation for constraint: string
        if (!is_null($resultat) && !is_string($resultat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultat)), __LINE__);
        }
        $this->Resultat = $resultat;
        return $this;
    }
    /**
     * Get CodeErreur value
     * @return string|null
     */
    public function getCodeErreur()
    {
        return $this->CodeErreur;
    }
    /**
     * Set CodeErreur value
     * @param string $codeErreur
     * @return \StructType\ReponseTarif
     */
    public function setCodeErreur($codeErreur = null)
    {
        // validation for constraint: string
        if (!is_null($codeErreur) && !is_string($codeErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeErreur)), __LINE__);
        }
        $this->CodeErreur = $codeErreur;
        return $this;
    }
    /**
     * Get LibelleErreur value
     * @return string|null
     */
    public function getLibelleErreur()
    {
        return $this->LibelleErreur;
    }
    /**
     * Set LibelleErreur value
     * @param string $libelleErreur
     * @return \StructType\ReponseTarif
     */
    public function setLibelleErreur($libelleErreur = null)
    {
        // validation for constraint: string
        if (!is_null($libelleErreur) && !is_string($libelleErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelleErreur)), __LINE__);
        }
        $this->LibelleErreur = $libelleErreur;
        return $this;
    }
    /**
     * Get ListeTarif value
     * @return \ArrayType\ArrayOfTarif|null
     */
    public function getListeTarif()
    {
        return $this->ListeTarif;
    }
    /**
     * Set ListeTarif value
     * @param \ArrayType\ArrayOfTarif $listeTarif
     * @return \StructType\ReponseTarif
     */
    public function setListeTarif(\ArrayType\ArrayOfTarif $listeTarif = null)
    {
        $this->ListeTarif = $listeTarif;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReponseTarif
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
