<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReponseInfosRelance StructType
 * @subpackage Structs
 */
class ReponseInfosRelance extends AbstractStructBase
{
    /**
     * The Resultat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Resultat;
    /**
     * The CodeErreur
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodeErreur;
    /**
     * The LibelleErreur
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibelleErreur;
    /**
     * The InfosRelance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InfosRelance
     */
    public $InfosRelance;
    /**
     * Constructor method for ReponseInfosRelance
     * @uses ReponseInfosRelance::setResultat()
     * @uses ReponseInfosRelance::setCodeErreur()
     * @uses ReponseInfosRelance::setLibelleErreur()
     * @uses ReponseInfosRelance::setInfosRelance()
     * @param bool $resultat
     * @param int $codeErreur
     * @param string $libelleErreur
     * @param \StructType\InfosRelance $infosRelance
     */
    public function __construct($resultat = null, $codeErreur = null, $libelleErreur = null, \StructType\InfosRelance $infosRelance = null)
    {
        $this
            ->setResultat($resultat)
            ->setCodeErreur($codeErreur)
            ->setLibelleErreur($libelleErreur)
            ->setInfosRelance($infosRelance);
    }
    /**
     * Get Resultat value
     * @return bool
     */
    public function getResultat()
    {
        return $this->Resultat;
    }
    /**
     * Set Resultat value
     * @param bool $resultat
     * @return \StructType\ReponseInfosRelance
     */
    public function setResultat($resultat = null)
    {
        // validation for constraint: boolean
        if (!is_null($resultat) && !is_bool($resultat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($resultat)), __LINE__);
        }
        $this->Resultat = $resultat;
        return $this;
    }
    /**
     * Get CodeErreur value
     * @return int
     */
    public function getCodeErreur()
    {
        return $this->CodeErreur;
    }
    /**
     * Set CodeErreur value
     * @param int $codeErreur
     * @return \StructType\ReponseInfosRelance
     */
    public function setCodeErreur($codeErreur = null)
    {
        // validation for constraint: int
        if (!is_null($codeErreur) && !is_numeric($codeErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codeErreur)), __LINE__);
        }
        $this->CodeErreur = $codeErreur;
        return $this;
    }
    /**
     * Get LibelleErreur value
     * @return string|null
     */
    public function getLibelleErreur()
    {
        return $this->LibelleErreur;
    }
    /**
     * Set LibelleErreur value
     * @param string $libelleErreur
     * @return \StructType\ReponseInfosRelance
     */
    public function setLibelleErreur($libelleErreur = null)
    {
        // validation for constraint: string
        if (!is_null($libelleErreur) && !is_string($libelleErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelleErreur)), __LINE__);
        }
        $this->LibelleErreur = $libelleErreur;
        return $this;
    }
    /**
     * Get InfosRelance value
     * @return \StructType\InfosRelance|null
     */
    public function getInfosRelance()
    {
        return $this->InfosRelance;
    }
    /**
     * Set InfosRelance value
     * @param \StructType\InfosRelance $infosRelance
     * @return \StructType\ReponseInfosRelance
     */
    public function setInfosRelance(\StructType\InfosRelance $infosRelance = null)
    {
        $this->InfosRelance = $infosRelance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReponseInfosRelance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
