<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activite StructType
 * @subpackage Structs
 */
class Activite extends AbstractStructBase
{
    /**
     * The CodeActivite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeActivite;
    /**
     * The Libelle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Libelle;
    /**
     * Constructor method for Activite
     * @uses Activite::setCodeActivite()
     * @uses Activite::setLibelle()
     * @param string $codeActivite
     * @param string $libelle
     */
    public function __construct($codeActivite = null, $libelle = null)
    {
        $this
            ->setCodeActivite($codeActivite)
            ->setLibelle($libelle);
    }
    /**
     * Get CodeActivite value
     * @return string|null
     */
    public function getCodeActivite()
    {
        return $this->CodeActivite;
    }
    /**
     * Set CodeActivite value
     * @param string $codeActivite
     * @return \StructType\Activite
     */
    public function setCodeActivite($codeActivite = null)
    {
        // validation for constraint: string
        if (!is_null($codeActivite) && !is_string($codeActivite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeActivite)), __LINE__);
        }
        $this->CodeActivite = $codeActivite;
        return $this;
    }
    /**
     * Get Libelle value
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->Libelle;
    }
    /**
     * Set Libelle value
     * @param string $libelle
     * @return \StructType\Activite
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: string
        if (!is_null($libelle) && !is_string($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelle)), __LINE__);
        }
        $this->Libelle = $libelle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Activite
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
