<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Planning ServiceType
 * @subpackage Services
 */
class Planning extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Planning
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Planning $parameters
     * @return \StructType\PlanningResponse|bool
     */
    public function Planning(\StructType\Planning $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Planning($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PlanningCTonline
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PlanningCTonline $parameters
     * @return \StructType\PlanningCTonlineResponse|bool
     */
    public function PlanningCTonline(\StructType\PlanningCTonline $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PlanningCTonline($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PlanningCTonlineResponse|\StructType\PlanningResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
